/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.webapp.handlers;

import com.microsoft.azure.management.appservice.PublishingProfile;
import com.microsoft.azure.management.appservice.WebApp;
import com.microsoft.azure.maven.FTPUploader;
import com.microsoft.azure.maven.Utils;
import com.microsoft.azure.maven.webapp.AbstractWebAppMojo;
import com.microsoft.azure.maven.webapp.handlers.ArtifactHandler;
import java.io.IOException;
import java.util.List;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Resource;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.filtering.MavenResourcesFiltering;

public class FTPArtifactHandlerImpl
implements ArtifactHandler {
    public static final String DEFAULT_WEBAPP_ROOT = "/site/wwwroot";
    public static final int DEFAULT_MAX_RETRY_TIMES = 3;
    public static final String NO_RESOURCES_CONFIG = "No resources specified in pom.xml. Skip artifacts deployment.";
    private AbstractWebAppMojo mojo;

    public FTPArtifactHandlerImpl(AbstractWebAppMojo mojo) {
        this.mojo = mojo;
    }

    @Override
    public void publish() throws Exception {
        List<Resource> resources = this.mojo.getResources();
        if (resources == null || resources.isEmpty()) {
            this.mojo.getLog().info((CharSequence)NO_RESOURCES_CONFIG);
            return;
        }
        this.copyResourcesToStageDirectory(resources);
        this.uploadDirectoryToFTP();
    }

    protected void copyResourcesToStageDirectory(List<Resource> resources) throws IOException {
        Utils.copyResources((MavenProject)this.mojo.getProject(), (MavenSession)this.mojo.getSession(), (MavenResourcesFiltering)this.mojo.getMavenResourcesFiltering(), resources, (String)this.mojo.getDeploymentStageDirectory());
    }

    protected void uploadDirectoryToFTP() throws Exception {
        FTPUploader uploader = this.getUploader();
        WebApp app = this.mojo.getWebApp();
        PublishingProfile profile = app.getPublishingProfile();
        String serverUrl = profile.ftpUrl().split("/", 2)[0];
        uploader.uploadDirectoryWithRetries(serverUrl, profile.ftpUsername(), profile.ftpPassword(), this.mojo.getDeploymentStageDirectory(), DEFAULT_WEBAPP_ROOT, 3);
    }

    protected FTPUploader getUploader() {
        return new FTPUploader(this.mojo.getLog());
    }
}

