/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.webapp;

import com.microsoft.azure.management.appservice.WebApp;
import com.microsoft.azure.maven.webapp.AbstractWebAppMojo;
import com.microsoft.azure.maven.webapp.handlers.HandlerFactory;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;

@Mojo(name="deploy", defaultPhase=LifecyclePhase.DEPLOY)
public class DeployMojo
extends AbstractWebAppMojo {
    public static final String WEBAPP_DEPLOY_START = "Start deploying to Web App %s...";
    public static final String WEBAPP_DEPLOY_SUCCESS = "Successfully deployed Web App at https://%s.azurewebsites.net";
    public static final String WEBAPP_NOT_EXIST = "Target Web App doesn't exist. Creating a new one...";
    public static final String WEBAPP_CREATED = "Successfully created Web App.";
    public static final String UPDATE_WEBAPP = "Updating target Web App...";
    public static final String UPDATE_WEBAPP_DONE = "Successfully updated Web App.";
    public static final String STOP_APP = "Stopping Web App before deploying artifacts...";
    public static final String START_APP = "Starting Web App after deploying artifacts...";
    public static final String STOP_APP_DONE = "Successfully stopped Web App.";
    public static final String START_APP_DONE = "Successfully started Web App.";
    protected DeploymentUtil util = new DeploymentUtil();

    protected void doExecute() throws Exception {
        this.getLog().info((CharSequence)String.format(WEBAPP_DEPLOY_START, this.getAppName()));
        this.createOrUpdateWebApp();
        this.deployArtifacts();
        this.getLog().info((CharSequence)String.format(WEBAPP_DEPLOY_SUCCESS, this.getAppName()));
    }

    protected void createOrUpdateWebApp() throws Exception {
        WebApp app = this.getWebApp();
        if (app == null) {
            this.createWebApp();
        } else {
            this.updateWebApp(app);
        }
    }

    protected void createWebApp() throws Exception {
        this.info(WEBAPP_NOT_EXIST);
        WebApp.DefinitionStages.WithCreate withCreate = this.getFactory().getRuntimeHandler(this).defineAppWithRuntime();
        this.getFactory().getSettingsHandler(this).processSettings(withCreate);
        withCreate.create();
        this.info(WEBAPP_CREATED);
    }

    protected void updateWebApp(WebApp app) throws Exception {
        this.info(UPDATE_WEBAPP);
        WebApp.Update update = this.getFactory().getRuntimeHandler(this).updateAppRuntime(app);
        this.getFactory().getSettingsHandler(this).processSettings(update);
        update.apply();
        this.info(UPDATE_WEBAPP_DONE);
    }

    protected void deployArtifacts() throws Exception {
        try {
            this.util.beforeDeployArtifacts();
            this.getFactory().getArtifactHandler(this).publish();
        }
        finally {
            this.util.afterDeployArtifacts();
        }
    }

    protected HandlerFactory getFactory() {
        return HandlerFactory.getInstance();
    }

    class DeploymentUtil {
        boolean isAppStopped = false;

        DeploymentUtil() {
        }

        public void beforeDeployArtifacts() throws Exception {
            if (DeployMojo.this.isStopAppDuringDeployment()) {
                DeployMojo.this.info(DeployMojo.STOP_APP);
                DeployMojo.this.getWebApp().stop();
                this.isAppStopped = true;
                DeployMojo.this.info(DeployMojo.STOP_APP_DONE);
            }
        }

        public void afterDeployArtifacts() throws Exception {
            if (this.isAppStopped) {
                DeployMojo.this.info(DeployMojo.START_APP);
                DeployMojo.this.getWebApp().start();
                this.isAppStopped = false;
                DeployMojo.this.info(DeployMojo.START_APP_DONE);
            }
        }
    }
}

