/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.webapp;

import com.microsoft.azure.management.appservice.JavaVersion;
import com.microsoft.azure.management.appservice.PricingTier;
import com.microsoft.azure.management.appservice.WebApp;
import com.microsoft.azure.management.appservice.WebContainer;
import com.microsoft.azure.maven.AbstractAzureMojo;
import com.microsoft.azure.maven.appservice.PricingTierEnum;
import com.microsoft.azure.maven.auth.AzureAuthFailureException;
import com.microsoft.azure.maven.webapp.WebAppUtils;
import com.microsoft.azure.maven.webapp.configuration.ContainerSetting;
import com.microsoft.azure.maven.webapp.configuration.DeploymentType;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.model.Resource;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.util.StringUtils;

public abstract class AbstractWebAppMojo
extends AbstractAzureMojo {
    public static final String JAVA_VERSION_KEY = "javaVersion";
    public static final String JAVA_WEB_CONTAINER_KEY = "javaWebContainer";
    public static final String LINUX_RUNTIME_KEY = "linuxRuntime";
    public static final String DOCKER_IMAGE_TYPE_KEY = "dockerImageType";
    public static final String DEPLOYMENT_TYPE_KEY = "deploymentType";
    @Parameter(property="webapp.resourceGroup", required=true)
    protected String resourceGroup;
    @Parameter(property="webapp.appName", required=true)
    protected String appName;
    @Parameter(property="webapp.appServicePlanResourceGroup")
    protected String appServicePlanResourceGroup;
    @Parameter(property="webapp.appServicePlanName")
    protected String appServicePlanName;
    @Parameter(property="webapp.region", defaultValue="westus")
    protected String region;
    @Parameter(property="webapp.pricingTier", defaultValue="S1")
    protected PricingTierEnum pricingTier;
    @Parameter(property="webapp.javaVersion")
    protected String javaVersion;
    @Parameter(property="webapp.javaWebContainer", defaultValue="tomcat 8.5")
    protected String javaWebContainer;
    @Parameter(property="webapp.linuxRuntime")
    protected String linuxRuntime;
    @Parameter
    protected ContainerSetting containerSettings;
    @Parameter
    protected Properties appSettings;
    @Parameter(property="webapp.deploymentType", defaultValue="war")
    protected String deploymentType;
    @Parameter(property="webapp.stopAppDuringDeployment", defaultValue="false")
    protected boolean stopAppDuringDeployment;
    @Parameter
    protected List<Resource> resources;
    @Parameter(property="webapp.skip", defaultValue="false")
    protected boolean skip;
    @Parameter(property="webapp.warFile")
    protected String warFile;
    @Parameter(property="webapp.path", defaultValue="/")
    protected String path;

    protected boolean isSkipMojo() {
        return this.skip;
    }

    public String getResourceGroup() {
        return this.resourceGroup;
    }

    public String getAppName() {
        return this.appName;
    }

    public String getAppServicePlanResourceGroup() {
        return this.appServicePlanResourceGroup;
    }

    public String getAppServicePlanName() {
        return this.appServicePlanName;
    }

    public String getRegion() {
        return this.region;
    }

    public PricingTier getPricingTier() {
        return this.pricingTier == null ? PricingTier.STANDARD_S1 : this.pricingTier.toPricingTier();
    }

    public JavaVersion getJavaVersion() {
        return StringUtils.isEmpty((String)this.javaVersion) ? null : JavaVersion.fromString((String)this.javaVersion);
    }

    public String getLinuxRuntime() {
        return this.linuxRuntime;
    }

    public WebContainer getJavaWebContainer() {
        return StringUtils.isEmpty((String)this.javaWebContainer) ? WebContainer.TOMCAT_8_5_NEWEST : WebContainer.fromString((String)this.javaWebContainer);
    }

    public ContainerSetting getContainerSettings() {
        return this.containerSettings;
    }

    public Map getAppSettings() {
        return this.appSettings;
    }

    public DeploymentType getDeploymentType() {
        return DeploymentType.fromString(this.deploymentType);
    }

    public boolean isStopAppDuringDeployment() {
        return this.stopAppDuringDeployment;
    }

    public String getDeploymentStageDirectory() {
        return Paths.get(this.getBuildDirectoryAbsolutePath(), "azure-webapps", this.getAppName()).toString();
    }

    public List<Resource> getResources() {
        return this.resources;
    }

    public String getWarFile() {
        return this.warFile;
    }

    public String getPath() {
        return this.path;
    }

    public WebApp getWebApp() throws AzureAuthFailureException {
        try {
            return (WebApp)this.getAzureClient().webApps().getByResourceGroup(this.getResourceGroup(), this.getAppName());
        }
        catch (AzureAuthFailureException authEx) {
            throw authEx;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Map<String, String> getTelemetryProperties() {
        Map map = super.getTelemetryProperties();
        map.put(JAVA_VERSION_KEY, StringUtils.isEmpty((String)this.javaVersion) ? "" : this.javaVersion);
        map.put(JAVA_WEB_CONTAINER_KEY, this.getJavaWebContainer().toString());
        map.put(LINUX_RUNTIME_KEY, StringUtils.isEmpty((String)this.linuxRuntime) ? "" : this.linuxRuntime);
        map.put(DOCKER_IMAGE_TYPE_KEY, WebAppUtils.getDockerImageType(this.getContainerSettings()).toString());
        map.put(DEPLOYMENT_TYPE_KEY, this.getDeploymentType().toString());
        return map;
    }
}

