/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.plugin.webapps.gradle;

import com.microsoft.azure.gradle.auth.GradleAuthConfig;
import com.microsoft.azure.gradle.auth.GradleAuthHelper;
import com.microsoft.azure.gradle.configuration.GradleDeploymentSlotConfig;
import com.microsoft.azure.gradle.configuration.GradleRuntimeConfig;
import com.microsoft.azure.gradle.configuration.GradleWebAppConfig;
import com.microsoft.azure.gradle.temeletry.TelemetryAgent;
import com.microsoft.azure.plugin.webapps.gradle.AzureWebappPluginExtension;
import com.microsoft.azure.toolkit.lib.Azure;
import com.microsoft.azure.toolkit.lib.appservice.AppServiceAppBase;
import com.microsoft.azure.toolkit.lib.appservice.config.AppServiceConfig;
import com.microsoft.azure.toolkit.lib.appservice.config.RuntimeConfig;
import com.microsoft.azure.toolkit.lib.appservice.model.OperatingSystem;
import com.microsoft.azure.toolkit.lib.appservice.model.PricingTier;
import com.microsoft.azure.toolkit.lib.appservice.model.WebAppArtifact;
import com.microsoft.azure.toolkit.lib.appservice.model.WebAppLinuxRuntime;
import com.microsoft.azure.toolkit.lib.appservice.plan.AppServicePlan;
import com.microsoft.azure.toolkit.lib.appservice.task.CreateOrUpdateWebAppTask;
import com.microsoft.azure.toolkit.lib.appservice.task.DeployWebAppTask;
import com.microsoft.azure.toolkit.lib.appservice.utils.AppServiceConfigUtils;
import com.microsoft.azure.toolkit.lib.appservice.utils.Utils;
import com.microsoft.azure.toolkit.lib.appservice.webapp.AzureWebApp;
import com.microsoft.azure.toolkit.lib.appservice.webapp.WebApp;
import com.microsoft.azure.toolkit.lib.appservice.webapp.WebAppBase;
import com.microsoft.azure.toolkit.lib.appservice.webapp.WebAppServiceSubscription;
import com.microsoft.azure.toolkit.lib.auth.AzureAccount;
import com.microsoft.azure.toolkit.lib.common.bundle.AzureString;
import com.microsoft.azure.toolkit.lib.common.exception.AzureToolkitRuntimeException;
import com.microsoft.azure.toolkit.lib.common.messager.AzureMessager;
import com.microsoft.azure.toolkit.lib.common.model.Region;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperation;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperationAspect;
import com.microsoft.azure.toolkit.lib.common.operation.OperationContext;
import com.microsoft.azure.toolkit.lib.common.proxy.ProxyManager;
import com.microsoft.azure.toolkit.lib.common.validator.SchemaValidator;
import com.microsoft.azure.toolkit.lib.common.validator.ValidationMessage;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.tasks.TaskAction;

public class DeployTask
extends DefaultTask {
    private static final String PROXY = "proxy";
    private static final String INVALID_PARAMETER_ERROR_MESSAGE = "Invalid values found in configuration, please correct the value with messages below:";
    private AzureWebappPluginExtension azureWebappExtension;
    private String artifactFile;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    @TaskAction
    @AzureOperation(name="user/webapp.deploy_app")
    public void deploy() throws GradleException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this));
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            try {
                ProxyManager.getInstance().applyProxy();
                OperationContext.current().setTelemetryProperty(PROXY, String.valueOf(ProxyManager.getInstance().isProxyEnabled()));
                OperationContext.current().setTelemetryProperties(this.azureWebappExtension.getTelemetryProperties());
                TelemetryAgent.getInstance().trackTaskStart(((Object)((Object)this)).getClass());
                GradleWebAppConfig config = this.parseConfiguration();
                this.normalizeConfigValue(config);
                this.validate(config);
                config.subscriptionId(GradleAuthHelper.login((GradleAuthConfig)this.azureWebappExtension.getAuth(), (String)config.subscriptionId()));
                this.azureWebappExtension.setSubscription(config.subscriptionId());
                ((WebAppServiceSubscription)((AzureWebApp)Azure.az(AzureWebApp.class)).webApps(config.subscriptionId()).getParent()).loadRuntimes();
                this.validateOnline(config);
                WebAppBase<?, ?, ?> target = this.createOrUpdateWebapp(config);
                this.deployArtifact(target, config);
                AzureMessager.getMessager().info(AzureString.format((String)"Application url: %s", (Object[])new Object[]{"https://" + target.getHostName()}));
                TelemetryAgent.getInstance().trackTaskSuccess(((Object)((Object)this)).getClass());
            }
            catch (Exception e) {
                AzureMessager.getMessager().error((Throwable)e);
                TelemetryAgent.getInstance().traceException(((Object)((Object)this)).getClass(), e);
                throw new GradleException("Cannot deploy web app due to error: " + e.getMessage(), (Throwable)e);
            }
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    protected void validateConfiguration(Consumer<ValidationMessage> validationMessageConsumer, Object rawConfig) {
        List validate = SchemaValidator.getInstance().validate("GradleWebAppConfiguration", rawConfig, "azurewebapp");
        validate.forEach(validationMessageConsumer);
        if (CollectionUtils.isNotEmpty((Collection)validate)) {
            String errorDetails = validate.stream().map(message -> message.getMessage().toString()).collect(Collectors.joining("\n"));
            throw new AzureToolkitRuntimeException(String.join((CharSequence)"\n", INVALID_PARAMETER_ERROR_MESSAGE, errorDetails));
        }
    }

    private void deployArtifact(WebAppBase<?, ?, ?> target, GradleWebAppConfig config) {
        new DeployWebAppTask(target, config.webAppArtifacts(), true).execute();
    }

    private void validateOnline(GradleWebAppConfig config) {
        List validRegions = ((AzureAccount)Azure.az(AzureAccount.class)).listRegions(config.subscriptionId()).stream().map(Region::getName).map(StringUtils::lowerCase).collect(Collectors.toList());
        if (StringUtils.isNotBlank((CharSequence)config.region()) && !validRegions.contains(config.region())) {
            throw new AzureToolkitRuntimeException(String.format("Unsupported region '%s' in current subscription, valid values are: %s.", config.region(), String.join((CharSequence)",", validRegions)));
        }
    }

    private void validate(GradleWebAppConfig config) {
        this.validateConfiguration(message -> AzureMessager.getMessager().error(message.getMessage()), config);
    }

    private WebAppBase<?, ?, ?> createOrUpdateWebapp(GradleWebAppConfig config) {
        AppServiceConfig appServiceConfig = this.convert(config);
        WebApp app = (WebApp)((AzureWebApp)Azure.az(AzureWebApp.class)).webApps(appServiceConfig.subscriptionId()).get(appServiceConfig.appName(), appServiceConfig.resourceGroup());
        boolean skipCreate = BooleanUtils.toBoolean((String)System.getProperty("azure.resource.create.skip", "false"));
        AppServiceConfig defaultConfig = app != null && app.exists() ? AppServiceConfigUtils.fromAppService((AppServiceAppBase)app, (AppServicePlan)Objects.requireNonNull(app.getAppServicePlan())) : this.buildDefaultConfig(appServiceConfig.subscriptionId(), appServiceConfig.resourceGroup(), appServiceConfig.appName());
        AppServiceConfigUtils.mergeAppServiceConfig((AppServiceConfig)appServiceConfig, (AppServiceConfig)defaultConfig);
        if (appServiceConfig.pricingTier() == null) {
            RuntimeConfig runtime = appServiceConfig.runtime();
            OperatingSystem operatingSystem = Optional.ofNullable(runtime).map(RuntimeConfig::os).orElse(null);
            String jboss = WebAppLinuxRuntime.JBOSS7_JAVA17.getContainerName();
            if (operatingSystem == OperatingSystem.LINUX && StringUtils.containsIgnoreCase((CharSequence)runtime.webContainer(), (CharSequence)jboss)) {
                appServiceConfig.pricingTier(PricingTier.PREMIUM_P1V3);
            } else {
                appServiceConfig.pricingTier(PricingTier.PREMIUM_P1V2);
            }
        }
        CreateOrUpdateWebAppTask task = new CreateOrUpdateWebAppTask(appServiceConfig);
        task.setSkipCreateAzureResource(skipCreate);
        return (WebAppBase)task.execute();
    }

    private AppServiceConfig buildDefaultConfig(String subscriptionId, String resourceGroup, String appName) {
        String packaging = FilenameUtils.getExtension((String)((String)StringUtils.firstNonBlank((CharSequence[])new String[]{this.artifactFile, ""})));
        return AppServiceConfigUtils.buildDefaultWebAppConfig((String)subscriptionId, (String)resourceGroup, (String)appName, (String)packaging);
    }

    private AppServiceConfig convert(GradleWebAppConfig config) {
        return new AppServiceConfig().subscriptionId(config.subscriptionId()).resourceGroup(config.resourceGroup()).appName(config.appName()).servicePlanName(config.servicePlanName()).servicePlanResourceGroup(config.servicePlanResourceGroup()).deploymentSlotName(config.deploymentSlotName()).deploymentSlotConfigurationSource(config.deploymentSlotConfigurationSource()).pricingTier((PricingTier)Optional.ofNullable(config.pricingTier()).map(PricingTier::fromString).orElse(null)).region((Region)Optional.ofNullable(config.region()).map(Region::fromName).orElse(null)).runtime(this.getRuntimeConfig(config)).servicePlanName(config.servicePlanName()).appSettings(config.appSettings());
    }

    private RuntimeConfig getRuntimeConfig(@Nonnull GradleWebAppConfig webAppConfig) {
        GradleRuntimeConfig config = webAppConfig.runtime();
        if (Objects.isNull(config)) {
            return null;
        }
        OperatingSystem os = Optional.ofNullable(config.os()).map(OperatingSystem::fromString).orElse(null);
        String javaVersion = Optional.of(config.javaVersion()).filter(StringUtils::isNotEmpty).orElse(null);
        String webContainer = Optional.of(config.webContainer()).filter(StringUtils::isNotEmpty).orElse(null);
        return new RuntimeConfig().os(os).webContainer(webContainer).javaVersion(javaVersion).registryUrl(config.registryUrl()).image(config.image()).username(config.username()).password(config.password()).startUpCommand(config.startUpCommand());
    }

    private GradleWebAppConfig parseConfiguration() {
        AzureWebappPluginExtension ctx = this.azureWebappExtension;
        GradleWebAppConfig config = new GradleWebAppConfig();
        config.subscriptionId(ctx.getSubscription());
        config.resourceGroup(ctx.getResourceGroup());
        config.appName(ctx.getAppName());
        config.pricingTier(ctx.getPricingTier());
        config.region(ctx.getRegion());
        config.runtime(ctx.getRuntime());
        config.appSettings(ctx.getAppSettings());
        config.servicePlanName(ctx.getAppServicePlanName());
        config.servicePlanResourceGroup(ctx.getAppServicePlanResourceGroup());
        config.deploymentSlotName((String)Optional.ofNullable(ctx.getDeploymentSlot()).map(GradleDeploymentSlotConfig::name).orElse(null));
        config.deploymentSlotConfigurationSource((String)Optional.ofNullable(ctx.getDeploymentSlot()).map(GradleDeploymentSlotConfig::configurationSource).orElse(null));
        if (StringUtils.isNotBlank((CharSequence)this.artifactFile)) {
            File file = new File(this.artifactFile);
            if (!file.exists()) {
                throw new AzureToolkitRuntimeException(String.format("artifact file(%s) cannot be found.", file.getAbsolutePath()));
            }
            WebAppArtifact webAppArtifact = WebAppArtifact.builder().deployType(Utils.getDeployTypeByFileExtension((File)file)).file(file).build();
            config.webAppArtifacts(Collections.singletonList(webAppArtifact));
        }
        return config;
    }

    private void normalizeConfigValue(GradleWebAppConfig config) {
        if (StringUtils.isNotBlank((CharSequence)config.region())) {
            config.region(Region.fromName((String)config.region()).getName());
        }
    }

    public void setAzureWebappExtension(AzureWebappPluginExtension azureWebappExtension) {
        this.azureWebappExtension = azureWebappExtension;
    }

    public void setArtifactFile(String artifactFile) {
        this.artifactFile = artifactFile;
    }

    static {
        DeployTask.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("DeployTask.java", DeployTask.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deploy", "com.microsoft.azure.plugin.webapps.gradle.DeployTask", "", "", "org.gradle.api.GradleException", "void"), 72);
    }
}

