/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.plugin.webapps.gradle;

import com.fasterxml.jackson.annotation.JsonSetter;
import com.microsoft.azure.gradle.auth.GradleAuthConfig;
import com.microsoft.azure.gradle.configuration.GradleDeploymentSlotConfig;
import com.microsoft.azure.gradle.configuration.GradleRuntimeConfig;
import com.microsoft.azure.toolkit.lib.appservice.model.OperatingSystem;
import com.microsoft.azure.toolkit.lib.legacy.appservice.DockerImageType;
import groovy.lang.Closure;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.gradle.api.Project;
import org.gradle.api.tasks.Input;

public class AzureWebappPluginExtension {
    public static final String JAVA_VERSION_KEY = "javaVersion";
    public static final String JAVA_WEB_CONTAINER_KEY = "javaWebContainer";
    public static final String DOCKER_IMAGE_TYPE_KEY = "dockerImageType";
    public static final String PRICING_TIER_KEY = "pricingTier";
    public static final String REGION_KEY = "region";
    public static final String OS_KEY = "os";
    public static final String SKIP_CREATE_RESOURCE_KEY = "skipCreateResource";
    public static final String DEPLOY_TO_SLOT_KEY = "isDeployToSlot";
    private Boolean allowTelemetry;
    private String subscription;
    private String resourceGroup;
    private String appName;
    private String region;
    private String pricingTier;
    private String appServicePlanResourceGroup;
    private String appServicePlanName;
    private GradleAuthConfig auth;
    private GradleRuntimeConfig runtime;
    private GradleDeploymentSlotConfig deploymentSlot;
    private Map<String, String> appSettings;
    private String appInsightsInstance;
    private String appInsightsKey;
    private Project project;

    @Input
    @org.gradle.api.tasks.Optional
    public String getResourceGroup() {
        return this.resourceGroup;
    }

    @Input
    public String getAppName() {
        return this.appName;
    }

    @Input
    @org.gradle.api.tasks.Optional
    public String getRegion() {
        return this.region;
    }

    @Input
    @org.gradle.api.tasks.Optional
    public String getSubscription() {
        return this.subscription;
    }

    @Input
    @org.gradle.api.tasks.Optional
    public String getPricingTier() {
        return this.pricingTier;
    }

    @Input
    @org.gradle.api.tasks.Optional
    public String getAppServicePlanName() {
        return this.appServicePlanName;
    }

    @Input
    @org.gradle.api.tasks.Optional
    public String getAppServicePlanResourceGroup() {
        return this.appServicePlanResourceGroup;
    }

    @Input
    @org.gradle.api.tasks.Optional
    @Deprecated
    public GradleAuthConfig getAuthentication() {
        return this.auth;
    }

    @Input
    @org.gradle.api.tasks.Optional
    public GradleAuthConfig getAuth() {
        return this.auth;
    }

    @Input
    @org.gradle.api.tasks.Optional
    public Map<String, String> getAppSettings() {
        return this.appSettings;
    }

    @Input
    @org.gradle.api.tasks.Optional
    public GradleRuntimeConfig getRuntime() {
        return this.runtime;
    }

    @Input
    @org.gradle.api.tasks.Optional
    public Boolean getAllowTelemetry() {
        return this.allowTelemetry;
    }

    @Input
    @org.gradle.api.tasks.Optional
    public String getAppInsightsInstance() {
        return this.appInsightsInstance;
    }

    @Input
    @org.gradle.api.tasks.Optional
    public String getAppInsightsKey() {
        return this.appInsightsKey;
    }

    @Input
    @org.gradle.api.tasks.Optional
    public GradleDeploymentSlotConfig getDeploymentSlot() {
        return this.deploymentSlot;
    }

    public void setAllowTelemetry(Boolean allowTelemetry) {
        this.allowTelemetry = allowTelemetry;
    }

    public void setResourceGroup(String resourceGroup) {
        this.resourceGroup = resourceGroup;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public void setSubscription(String subscription) {
        this.subscription = subscription;
    }

    public void setPricingTier(String pricingTier) {
        this.pricingTier = pricingTier;
    }

    @Deprecated
    public void setAuthentication(Closure closure) {
        this.auth = new GradleAuthConfig();
        this.project.configure((Object)this.auth, closure);
    }

    public void setAuth(Closure closure) {
        this.auth = new GradleAuthConfig();
        this.project.configure((Object)this.auth, closure);
    }

    public void setRuntime(Closure closure) {
        this.runtime = new GradleRuntimeConfig();
        this.project.configure((Object)this.runtime, closure);
    }

    public void setDeploymentSlot(Closure closure) {
        this.deploymentSlot = new GradleDeploymentSlotConfig();
        this.project.configure((Object)this.deploymentSlot, closure);
    }

    public void setAppServicePlanName(String appServicePlanName) {
        this.appServicePlanName = appServicePlanName;
    }

    public void setAppServicePlanResourceGroup(String appServicePlanResourceGroup) {
        this.appServicePlanResourceGroup = appServicePlanResourceGroup;
    }

    public void setAppSettings(Closure closure) {
        this.appSettings = new HashMap<String, String>();
        this.project.configure(this.appSettings, closure);
    }

    public void setAppInsightsInstance(@Nullable String appInsightsInstance) {
        this.appInsightsInstance = appInsightsInstance;
    }

    public void setAppInsightsKey(@Nullable String appInsightsKey) {
        this.appInsightsKey = appInsightsKey;
    }

    @JsonSetter
    public void setAuth(GradleAuthConfig auth) {
        this.auth = auth;
    }

    @JsonSetter
    public void setRuntime(GradleRuntimeConfig runtime) {
        this.runtime = runtime;
    }

    @JsonSetter
    public void setDeploymentSlot(GradleDeploymentSlotConfig deploymentSlot) {
        this.deploymentSlot = deploymentSlot;
    }

    @JsonSetter
    public void setAppSettings(Map<String, String> appSettings) {
        this.appSettings = appSettings;
    }

    public AzureWebappPluginExtension(@Nonnull Project project) {
        this.project = project;
    }

    public Map<String, String> getTelemetryProperties() {
        HashMap<String, String> result = new HashMap<String, String>();
        GradleRuntimeConfig runtime = this.getRuntime();
        String os = Optional.ofNullable(runtime).map(GradleRuntimeConfig::os).orElse("");
        result.put(OS_KEY, os);
        result.put(JAVA_VERSION_KEY, Optional.ofNullable(runtime).map(GradleRuntimeConfig::javaVersion).orElse(""));
        result.put(JAVA_WEB_CONTAINER_KEY, Optional.ofNullable(runtime).map(GradleRuntimeConfig::webContainer).orElse(""));
        result.put(PRICING_TIER_KEY, this.pricingTier);
        result.put(REGION_KEY, this.region);
        if (runtime != null && StringUtils.equalsIgnoreCase((CharSequence)os, (CharSequence)OperatingSystem.DOCKER.getValue())) {
            boolean isCustomRegistry = StringUtils.isNotEmpty((CharSequence)runtime.registryUrl());
            DockerImageType imageType = isCustomRegistry ? (StringUtils.isEmpty((CharSequence)runtime.password()) ? DockerImageType.PRIVATE_REGISTRY : DockerImageType.UNKNOWN) : (StringUtils.isEmpty((CharSequence)runtime.password()) ? DockerImageType.PRIVATE_DOCKER_HUB : DockerImageType.PUBLIC_DOCKER_HUB);
            result.put(DOCKER_IMAGE_TYPE_KEY, imageType.name());
        } else {
            result.put(DOCKER_IMAGE_TYPE_KEY, DockerImageType.NONE.toString());
        }
        boolean isDeployToSlot = Optional.ofNullable(this.getDeploymentSlot()).map(GradleDeploymentSlotConfig::name).map(StringUtils::isNotEmpty).orElse(false);
        result.put(DEPLOY_TO_SLOT_KEY, String.valueOf(isDeployToSlot));
        result.put(SKIP_CREATE_RESOURCE_KEY, System.getProperty("azure.resource.create.skip", "false"));
        return result;
    }

    public AzureWebappPluginExtension() {
    }
}

