/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.plugin.webapps.gradle;

import com.microsoft.azure.gradle.temeletry.TelemetryAgent;
import com.microsoft.azure.gradle.util.GradleAzureMessager;
import com.microsoft.azure.plugin.webapps.gradle.AzureWebappPluginExtension;
import com.microsoft.azure.plugin.webapps.gradle.DeployTask;
import com.microsoft.azure.toolkit.lib.appservice.model.OperatingSystem;
import com.microsoft.azure.toolkit.lib.common.messager.AzureMessager;
import com.microsoft.azure.toolkit.lib.common.messager.IAzureMessager;
import java.util.Optional;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.UnknownTaskException;
import org.gradle.api.file.FileCollection;
import org.gradle.api.plugins.WarPlugin;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskOutputs;
import org.gradle.api.tasks.TaskProvider;

public class AzureWebappPlugin
implements Plugin<Project> {
    public static final String GRADLE_PLUGIN_NAME = "azure-webapp-gradle-plugin";
    private static final String GRADLE_FUNCTION_EXTENSION = "azurewebapp";

    public void apply(Project project) {
        AzureWebappPluginExtension extension = (AzureWebappPluginExtension)project.getExtensions().create(GRADLE_FUNCTION_EXTENSION, AzureWebappPluginExtension.class, new Object[]{project});
        AzureMessager.setDefaultMessager((IAzureMessager)new GradleAzureMessager(project.getLogger()));
        String pluginVersion = (String)StringUtils.firstNonBlank((CharSequence[])new String[]{AzureWebappPlugin.class.getPackage().getImplementationVersion(), "develop"});
        TelemetryAgent.getInstance().initTelemetry(GRADLE_PLUGIN_NAME, pluginVersion, BooleanUtils.isNotFalse((Boolean)extension.getAllowTelemetry()));
        TelemetryAgent.getInstance().showPrivacyStatement();
        TaskContainer tasks = project.getTasks();
        TaskProvider deployTask = tasks.register("azureWebAppDeploy", DeployTask.class, task -> {
            task.setGroup("AzureWebapp");
            task.setDescription("Deploy current project to azure webapp.");
            task.setAzureWebappExtension(extension);
        });
        project.afterEvaluate(projectAfterEvaluation -> {
            TaskProvider<Task> warTask = AzureWebappPlugin.getWarTaskProvider(projectAfterEvaluation);
            TaskProvider<Task> bootWarTask = AzureWebappPlugin.getBootWarTaskProvider(projectAfterEvaluation);
            TaskProvider<Task> bootJarTask = AzureWebappPlugin.getBootJarTaskProvider(projectAfterEvaluation);
            TaskProvider jarTask = projectAfterEvaluation.getTasks().named("jar");
            deployTask.configure(task -> {
                boolean isDocker;
                boolean bl = isDocker = extension.getRuntime() != null && OperatingSystem.fromString((String)extension.getRuntime().os()) == OperatingSystem.DOCKER;
                if (extension.getRuntime() != null && StringUtils.isBlank((CharSequence)extension.getRuntime().os())) {
                    isDocker = StringUtils.isNotBlank((CharSequence)extension.getRuntime().image());
                }
                if (!isDocker) {
                    TaskProvider targetTask = (TaskProvider)ObjectUtils.firstNonNull((Object[])new TaskProvider[]{bootWarTask, bootJarTask, warTask, jarTask});
                    task.dependsOn(new Object[]{targetTask});
                    task.setArtifactFile(Optional.ofNullable(targetTask).map(Provider::get).map(Task::getOutputs).map(TaskOutputs::getFiles).map(FileCollection::getAsPath).orElse(null));
                }
            });
        });
    }

    static TaskProvider<Task> getWarTaskProvider(Project project) {
        if (project.getPlugins().hasPlugin(WarPlugin.class)) {
            return project.getTasks().named("war");
        }
        return null;
    }

    static TaskProvider<Task> getBootJarTaskProvider(Project project) {
        if (project.getPlugins().hasPlugin("org.springframework.boot")) {
            try {
                return project.getTasks().named("bootJar");
            }
            catch (UnknownTaskException unknownTaskException) {
                // empty catch block
            }
        }
        return null;
    }

    static TaskProvider<Task> getBootWarTaskProvider(Project project) {
        if (project.getPlugins().hasPlugin("org.springframework.boot")) {
            try {
                return project.getTasks().named("bootWar");
            }
            catch (UnknownTaskException unknownTaskException) {
                // empty catch block
            }
        }
        return null;
    }
}

