/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.common.utils;

import com.google.common.base.Preconditions;
import org.apache.commons.lang3.StringUtils;
import org.fusesource.jansi.Ansi;

public class TextUtils {
    public static String applyColorToText(String text, Ansi.Color colorCode) {
        if (StringUtils.isBlank((CharSequence)text)) {
            return text;
        }
        return Ansi.ansi().fg(colorCode).a(text).reset().toString();
    }

    public static String yellow(String message) {
        return TextUtils.applyColorToText(message, Ansi.Color.YELLOW);
    }

    public static String green(String message) {
        return TextUtils.applyColorToText(message, Ansi.Color.GREEN);
    }

    public static String blue(String message) {
        return TextUtils.applyColorToText(message, Ansi.Color.BLUE);
    }

    public static String red(String message) {
        return TextUtils.applyColorToText(message, Ansi.Color.RED);
    }

    public static String[] splitLines(String text) {
        Preconditions.checkNotNull((Object)text, (Object)"The parameter 'text' cannot be null");
        return text.split("\\r?\\n");
    }

    private TextUtils() {
    }
}

