/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.common.function.handlers.runtime;

import com.microsoft.azure.common.docker.IDockerCredentialProvider;
import com.microsoft.azure.common.exceptions.AzureExecutionException;
import com.microsoft.azure.common.function.configurations.FunctionExtensionVersion;
import com.microsoft.azure.common.function.configurations.RuntimeConfiguration;
import com.microsoft.azure.common.handlers.runtime.BaseRuntimeHandler;
import com.microsoft.azure.common.logging.Log;
import com.microsoft.azure.management.appservice.AppServicePlan;
import com.microsoft.azure.management.appservice.FunctionApp;
import com.microsoft.azure.management.appservice.JavaVersion;
import com.microsoft.azure.management.resources.ResourceGroup;
import org.apache.commons.lang3.StringUtils;

public abstract class FunctionRuntimeHandler
extends BaseRuntimeHandler<FunctionApp> {
    private static final JavaVersion DEFAULT_JAVA_VERSION = JavaVersion.JAVA_8_NEWEST;
    private static final String INVALID_JAVA_VERSION = "Invalid java version %s, using default value java 8";
    private static final String UNSUPPORTED_JAVA_VERSION = "Unsupported java version %s, using default value java 8";
    protected FunctionExtensionVersion functionExtensionVersion;
    protected RuntimeConfiguration runtimeConfiguration;
    protected IDockerCredentialProvider dockerCredentialProvider;
    protected JavaVersion javaVersion;

    protected FunctionRuntimeHandler(Builder<?> builder) {
        super(builder);
        this.functionExtensionVersion = builder.functionExtensionVersion;
        this.runtimeConfiguration = builder.runtimeConfiguration;
        this.dockerCredentialProvider = builder.dockerCredentialProvider;
        this.javaVersion = this.parseJavaVersion();
    }

    public abstract FunctionApp.DefinitionStages.WithCreate defineAppWithRuntime() throws AzureExecutionException;

    public abstract FunctionApp.Update updateAppRuntime(FunctionApp var1) throws AzureExecutionException;

    @Override
    protected void changeAppServicePlan(FunctionApp app, AppServicePlan appServicePlan) throws AzureExecutionException {
        ((FunctionApp.Update)app.update()).withExistingAppServicePlan(appServicePlan).apply();
    }

    protected FunctionApp.DefinitionStages.Blank defineFunction() {
        return (FunctionApp.DefinitionStages.Blank)this.azure.appServices().functionApps().define(this.appName);
    }

    protected ResourceGroup getResourceGroup() {
        return (ResourceGroup)this.azure.resourceGroups().getByName(this.resourceGroup);
    }

    private JavaVersion parseJavaVersion() {
        String javaVersionConfiguration = this.runtimeConfiguration.getJavaVersion();
        if (StringUtils.isEmpty((CharSequence)javaVersionConfiguration)) {
            return DEFAULT_JAVA_VERSION;
        }
        try {
            int version = Integer.valueOf(this.runtimeConfiguration.getJavaVersion());
            switch (version) {
                case 8: {
                    return JavaVersion.JAVA_8_NEWEST;
                }
                case 11: {
                    Log.info("Using Java 11 (Preview) runtime.");
                    return JavaVersion.JAVA_11;
                }
            }
            Log.warn(String.format(UNSUPPORTED_JAVA_VERSION, version));
            return DEFAULT_JAVA_VERSION;
        }
        catch (NumberFormatException e) {
            Log.warn(String.format(INVALID_JAVA_VERSION, this.runtimeConfiguration.getJavaVersion()));
            return DEFAULT_JAVA_VERSION;
        }
    }

    public static abstract class Builder<T extends Builder<T>>
    extends BaseRuntimeHandler.Builder<T> {
        protected FunctionExtensionVersion functionExtensionVersion;
        protected RuntimeConfiguration runtimeConfiguration;
        protected IDockerCredentialProvider dockerCredentialProvider;

        public T functionExtensionVersion(FunctionExtensionVersion value) {
            this.functionExtensionVersion = value;
            return (T)this.self();
        }

        public T runtime(RuntimeConfiguration value) {
            this.runtimeConfiguration = value;
            return (T)this.self();
        }

        public T dockerCredentialProvider(IDockerCredentialProvider value) {
            this.dockerCredentialProvider = value;
            return (T)this.self();
        }

        @Override
        public abstract FunctionRuntimeHandler build();

        @Override
        protected abstract T self();
    }
}

