/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.common.function.handlers.runtime;

import com.microsoft.azure.common.function.configurations.FunctionExtensionVersion;
import com.microsoft.azure.common.function.handlers.runtime.FunctionRuntimeHandler;
import com.microsoft.azure.common.logging.Log;
import com.microsoft.azure.management.appservice.AppServicePlan;
import com.microsoft.azure.management.appservice.FunctionApp;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractLinuxFunctionRuntimeHandler
extends FunctionRuntimeHandler {
    private static final FunctionExtensionVersion LINUX_MINIMUM_VERSION = FunctionExtensionVersion.VERSION_3;
    private static final String FUNCTION_EXTENSION_VERSION_NOT_SUPPORTED = "Linux function is not fully supported in current version %s, please set `FUNCTION_EXTENSION_VERSION` to `~3` for better experience";

    protected AbstractLinuxFunctionRuntimeHandler(FunctionRuntimeHandler.Builder builder) {
        super(builder);
    }

    protected FunctionApp.DefinitionStages.WithDockerContainerImage defineLinuxFunction() {
        FunctionApp.DefinitionStages.WithDockerContainerImage result;
        AppServicePlan appServicePlan = this.getAppServicePlan();
        FunctionApp.DefinitionStages.Blank blankFunctionApp = this.defineFunction();
        if (appServicePlan == null) {
            FunctionApp.DefinitionStages.NewAppServicePlanWithGroup appWithNewServicePlan = (FunctionApp.DefinitionStages.NewAppServicePlanWithGroup)blankFunctionApp.withRegion(this.region);
            FunctionApp.DefinitionStages.WithCreate withCreate = this.getResourceGroup() == null ? appWithNewServicePlan.withNewResourceGroup(this.resourceGroup) : appWithNewServicePlan.withExistingResourceGroup(this.resourceGroup);
            result = this.pricingTier == null ? (StringUtils.isEmpty((CharSequence)this.servicePlanName) ? withCreate.withNewLinuxConsumptionPlan() : withCreate.withNewLinuxConsumptionPlan(this.servicePlanName)) : (StringUtils.isEmpty((CharSequence)this.servicePlanName) ? withCreate.withNewLinuxAppServicePlan(this.pricingTier) : withCreate.withNewLinuxAppServicePlan(this.servicePlanName, this.pricingTier));
        } else {
            FunctionApp.DefinitionStages.ExistingLinuxPlanWithGroup appWithExistingServicePlan = blankFunctionApp.withExistingLinuxAppServicePlan(appServicePlan);
            result = this.getResourceGroup() == null ? appWithExistingServicePlan.withNewResourceGroup(this.resourceGroup) : appWithExistingServicePlan.withExistingResourceGroup(this.resourceGroup);
        }
        return result;
    }

    protected void checkFunctionExtensionVersion() {
        if (this.functionExtensionVersion.getValue() < LINUX_MINIMUM_VERSION.getValue()) {
            Log.warn(String.format(FUNCTION_EXTENSION_VERSION_NOT_SUPPORTED, this.functionExtensionVersion.getVersion()));
        }
    }
}

