/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.common.function.handlers.runtime;

import com.microsoft.azure.common.docker.IDockerCredentialProvider;
import com.microsoft.azure.common.exceptions.AzureExecutionException;
import com.microsoft.azure.common.function.configurations.FunctionExtensionVersion;
import com.microsoft.azure.common.function.configurations.RuntimeConfiguration;
import com.microsoft.azure.common.handlers.runtime.BaseRuntimeHandler;
import com.microsoft.azure.management.appservice.AppServicePlan;
import com.microsoft.azure.management.appservice.FunctionApp;
import com.microsoft.azure.management.resources.ResourceGroup;

public abstract class FunctionRuntimeHandler
extends BaseRuntimeHandler<FunctionApp> {
    protected FunctionExtensionVersion functionExtensionVersion;
    protected RuntimeConfiguration runtimeConfiguration;
    protected IDockerCredentialProvider dockerCredentialProvider;

    protected FunctionRuntimeHandler(Builder<?> builder) {
        super(builder);
        this.functionExtensionVersion = builder.functionExtensionVersion;
        this.runtimeConfiguration = builder.runtimeConfiguration;
        this.dockerCredentialProvider = builder.dockerCredentialProvider;
    }

    public abstract FunctionApp.DefinitionStages.WithCreate defineAppWithRuntime() throws AzureExecutionException;

    public abstract FunctionApp.Update updateAppRuntime(FunctionApp var1) throws AzureExecutionException;

    @Override
    protected void changeAppServicePlan(FunctionApp app, AppServicePlan appServicePlan) throws AzureExecutionException {
        ((FunctionApp.Update)app.update()).withExistingAppServicePlan(appServicePlan).apply();
    }

    protected FunctionApp.DefinitionStages.Blank defineFunction() {
        return (FunctionApp.DefinitionStages.Blank)this.azure.appServices().functionApps().define(this.appName);
    }

    protected ResourceGroup getResourceGroup() {
        return (ResourceGroup)this.azure.resourceGroups().getByName(this.resourceGroup);
    }

    public static abstract class Builder<T extends Builder<T>>
    extends BaseRuntimeHandler.Builder<T> {
        protected FunctionExtensionVersion functionExtensionVersion;
        protected RuntimeConfiguration runtimeConfiguration;
        protected IDockerCredentialProvider dockerCredentialProvider;

        public T functionExtensionVersion(FunctionExtensionVersion value) {
            this.functionExtensionVersion = value;
            return (T)this.self();
        }

        public T runtime(RuntimeConfiguration value) {
            this.runtimeConfiguration = value;
            return (T)this.self();
        }

        public T dockerCredentialProvider(IDockerCredentialProvider value) {
            this.dockerCredentialProvider = value;
            return (T)this.self();
        }

        @Override
        public abstract FunctionRuntimeHandler build();

        @Override
        protected abstract T self();
    }
}

