/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.common.function.handlers.artifact;

import com.microsoft.azure.common.deploytarget.DeployTarget;
import com.microsoft.azure.common.exceptions.AzureExecutionException;
import com.microsoft.azure.common.function.AzureStorageHelper;
import com.microsoft.azure.common.function.handlers.artifact.FunctionArtifactHelper;
import com.microsoft.azure.common.handlers.artifact.ArtifactHandlerBase;
import com.microsoft.azure.common.logging.Log;
import com.microsoft.azure.storage.CloudStorageAccount;
import com.microsoft.azure.storage.blob.CloudBlob;
import com.microsoft.azure.storage.blob.CloudBlockBlob;
import java.io.File;
import java.time.Period;

public class RunFromBlobArtifactHandlerImpl
extends ArtifactHandlerBase {
    public static final int SAS_EXPIRE_DATE_BY_YEAR = 10;
    public static final String DEPLOYMENT_PACKAGE_CONTAINER = "java-functions-run-from-packages";

    protected RunFromBlobArtifactHandlerImpl(Builder builder) {
        super(builder);
    }

    public void publish(DeployTarget deployTarget) throws AzureExecutionException {
        File zipPackage = FunctionArtifactHelper.createFunctionArtifact(this.stagingDirectoryPath);
        CloudStorageAccount storageAccount = FunctionArtifactHelper.getCloudStorageAccount(deployTarget);
        CloudBlockBlob blob = this.deployArtifactToAzureStorage(deployTarget, zipPackage, storageAccount);
        String sasToken = AzureStorageHelper.getSASToken((CloudBlob)blob, Period.ofYears(10));
        FunctionArtifactHelper.updateAppSetting(deployTarget, "WEBSITE_RUN_FROM_PACKAGE", sasToken);
    }

    private CloudBlockBlob deployArtifactToAzureStorage(DeployTarget deployTarget, File zipPackage, CloudStorageAccount storageAccount) throws AzureExecutionException {
        Log.prompt(String.format("Trying to deploy artifact to %s...", deployTarget.getName()));
        CloudBlockBlob blob = AzureStorageHelper.uploadFileAsBlob(zipPackage, storageAccount, DEPLOYMENT_PACKAGE_CONTAINER, zipPackage.getName());
        String blobUri = blob.getUri().getHost() + blob.getUri().getPath();
        Log.prompt(String.format("Successfully deployed the artifact to https://%s", blobUri));
        return blob;
    }

    public static class Builder
    extends ArtifactHandlerBase.Builder<Builder> {
        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public RunFromBlobArtifactHandlerImpl build() {
            return new RunFromBlobArtifactHandlerImpl(this);
        }
    }
}

