/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.storage.queue;

import com.azure.storage.queue.QueueClient;
import com.azure.storage.queue.QueueServiceClient;
import com.microsoft.azure.toolkit.lib.common.bundle.AzureString;
import com.microsoft.azure.toolkit.lib.common.exception.AzureToolkitRuntimeException;
import com.microsoft.azure.toolkit.lib.common.messager.AzureMessager;
import com.microsoft.azure.toolkit.lib.common.messager.IAzureMessager;
import com.microsoft.azure.toolkit.lib.common.model.AzResource;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperation;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperationAspect;
import com.microsoft.azure.toolkit.lib.storage.queue.Queue;
import com.microsoft.azure.toolkit.lib.storage.queue.QueueModule;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public class QueueDraft
extends Queue
implements AzResource.Draft<Queue, QueueClient> {
    @Nullable
    private final Queue origin;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    QueueDraft(@Nonnull String name, @Nonnull QueueModule module) {
        super(name, module);
        this.origin = null;
    }

    QueueDraft(@Nonnull Queue origin) {
        super(origin);
        this.origin = origin;
    }

    public void reset() {
    }

    @Nonnull
    @AzureOperation(name="azure/storage.create_queue.queue", params={"this.getName()"})
    public QueueClient createResourceInAzure() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this));
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            QueueModule module = (QueueModule)this.getModule();
            QueueServiceClient client = module.getQueueServiceClient();
            IAzureMessager messager = AzureMessager.getMessager();
            messager.info(AzureString.format((String)"Start creating Queue ({0}).", (Object[])new Object[]{this.getName()}));
            QueueClient queue = client.createQueue(this.getName());
            messager.success(AzureString.format((String)"Queue ({0}) is successfully created.", (Object[])new Object[]{this.getName()}));
            QueueClient queueClient = queue;
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return queueClient;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    @Nonnull
    @AzureOperation(name="azure/storage.update_queue.queue", params={"this.getName()"})
    public QueueClient updateResourceInAzure(@Nonnull QueueClient origin) {
        QueueClient queueClient = origin;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)((Object)this), (Object)((Object)this), (Object)queueClient);
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            throw new AzureToolkitRuntimeException("not supported");
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    public boolean isModified() {
        return false;
    }

    @Nullable
    public Queue getOrigin() {
        return this.origin;
    }

    static {
        QueueDraft.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("QueueDraft.java", QueueDraft.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "createResourceInAzure", "com.microsoft.azure.toolkit.lib.storage.queue.QueueDraft", "", "", "", "com.azure.storage.queue.QueueClient"), 45);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateResourceInAzure", "com.microsoft.azure.toolkit.lib.storage.queue.QueueDraft", "com.azure.storage.queue.QueueClient", "origin", "", "com.azure.storage.queue.QueueClient"), 58);
    }
}

