/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.springcloud.model;

import com.azure.resourcemanager.appplatform.models.SkuName;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class Sku {
    public static final Sku BASIC = new Sku(SkuName.B0.toString(), "Basic");
    public static final Sku STANDARD = new Sku(SkuName.S0.toString(), "Standard");
    public static final Sku ENTERPRISE = new Sku(SkuName.E0.toString(), "Enterprise");
    public static final Sku CONSUMPTION = new Sku(SkuName.S0.toString(), "StandardGen2");
    public static final List<Sku> KNOWN_SKUS = Collections.unmodifiableList(Arrays.asList(BASIC, STANDARD, ENTERPRISE, CONSUMPTION));
    public static final String CONSUMPTION_DISPLAY_NAME = "Consumption";
    public static final Sku SPRING_APPS_DEFAULT_SKU = CONSUMPTION;
    @Nonnull
    private final String name;
    @Nonnull
    private final String tier;

    public Sku(com.azure.resourcemanager.appplatform.models.Sku sku) {
        this.name = sku.name();
        this.tier = sku.tier();
    }

    public String getLabel() {
        if ("StandardGen2".equalsIgnoreCase(this.tier)) {
            return "Standard Consumption & Dedicated (preview)";
        }
        if (this.name.equalsIgnoreCase(SkuName.B0.toString())) {
            return "Basic";
        }
        if (this.name.equalsIgnoreCase(SkuName.S0.toString())) {
            return "Standard";
        }
        if (this.name.equalsIgnoreCase(SkuName.E0.toString())) {
            return "Enterprise";
        }
        return this.tier + " " + this.name;
    }

    public int getOrdinal() {
        if ("StandardGen2".equalsIgnoreCase(this.tier)) {
            return 0;
        }
        if (this.name.equalsIgnoreCase(SkuName.B0.toString())) {
            return 1;
        }
        if (this.name.equalsIgnoreCase(SkuName.S0.toString())) {
            return 2;
        }
        if (this.name.equalsIgnoreCase(SkuName.E0.toString())) {
            return 3;
        }
        return 4;
    }

    public String getDescription() {
        if ("StandardGen2".equalsIgnoreCase(this.tier)) {
            return "0 base price + actual usage, 400/1000 app instances max.";
        }
        if (this.name.equalsIgnoreCase(SkuName.B0.toString())) {
            return "2 vCPUs, 4 Gi included, 25 app instances max.";
        }
        if (this.name.equalsIgnoreCase(SkuName.S0.toString())) {
            return "6 vCPUs, 12 Gi included, 500 app instances max.";
        }
        if (this.name.equalsIgnoreCase(SkuName.E0.toString())) {
            return "6 vCPUs, 12 Gi included, 1000 app instances max.";
        }
        return this.tier + " " + this.name;
    }

    public boolean isEnterpriseTier() {
        return this.name.equalsIgnoreCase(SkuName.E0.toString());
    }

    public boolean isBasicTier() {
        return this.name.equalsIgnoreCase(SkuName.B0.toString());
    }

    public boolean isStandardTier() {
        return this.name.equalsIgnoreCase(SkuName.S0.toString());
    }

    public boolean isConsumptionTier() {
        return "StandardGen2".equalsIgnoreCase(this.tier);
    }

    public com.azure.resourcemanager.appplatform.models.Sku toSku() {
        return new com.azure.resourcemanager.appplatform.models.Sku().withName(this.name).withTier(this.tier);
    }

    @Nullable
    public static Sku fromString(String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return null;
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)value, (CharSequence)CONSUMPTION_DISPLAY_NAME)) {
            return CONSUMPTION;
        }
        return KNOWN_SKUS.stream().filter(sku -> StringUtils.equalsIgnoreCase((CharSequence)value, (CharSequence)sku.toString())).findFirst().orElseGet(() -> {
            String[] split = value.split("/");
            return ArrayUtils.getLength((Object)split) > 1 ? new Sku(split[1], split[0]) : new Sku(value, value);
        });
    }

    public String toString() {
        if (this.equals(CONSUMPTION)) {
            return CONSUMPTION_DISPLAY_NAME;
        }
        return KNOWN_SKUS.stream().filter(sku -> sku.equals(this)).findFirst().map(Sku::getTier).orElseGet(() -> this.tier + "/" + this.name);
    }

    public static Sku fromSku(com.azure.resourcemanager.appplatform.models.Sku sku) {
        return new Sku(sku);
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    @Nonnull
    public String getTier() {
        return this.tier;
    }

    public Sku(@Nonnull String name, @Nonnull String tier) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (tier == null) {
            throw new NullPointerException("tier is marked non-null but is null");
        }
        this.name = name;
        this.tier = tier;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Sku)) {
            return false;
        }
        Sku other = (Sku)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$tier = this.getTier();
        String other$tier = other.getTier();
        return !(this$tier == null ? other$tier != null : !this$tier.equals(other$tier));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Sku;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $tier = this.getTier();
        result = result * 59 + ($tier == null ? 43 : $tier.hashCode());
        return result;
    }
}

