/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.springcloud;

import com.azure.core.management.Region;
import com.azure.resourcemanager.appplatform.AppPlatformManager;
import com.azure.resourcemanager.appplatform.fluent.AppPlatformManagementClient;
import com.azure.resourcemanager.appplatform.models.NameAvailability;
import com.azure.resourcemanager.appplatform.models.NameAvailabilityParameters;
import com.azure.resourcemanager.appplatform.models.ResourceSku;
import com.azure.resourcemanager.appplatform.models.RuntimeVersion;
import com.azure.resourcemanager.appplatform.models.SupportedRuntimePlatform;
import com.azure.resourcemanager.appplatform.models.SupportedRuntimeVersion;
import com.azure.resourcemanager.resources.ResourceManager;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResourceModule;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzServiceSubscription;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperation;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperationAspect;
import com.microsoft.azure.toolkit.lib.common.utils.Utils;
import com.microsoft.azure.toolkit.lib.springcloud.AzureSpringCloud;
import com.microsoft.azure.toolkit.lib.springcloud.SpringCloudClusterModule;
import com.microsoft.azure.toolkit.lib.springcloud.model.Sku;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public class SpringCloudServiceSubscription
extends AbstractAzServiceSubscription<SpringCloudServiceSubscription, AppPlatformManager> {
    @Nonnull
    private final String subscriptionId;
    @Nonnull
    private final SpringCloudClusterModule clusterModule;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    SpringCloudServiceSubscription(@Nonnull String subscriptionId, @Nonnull AzureSpringCloud service) {
        super(subscriptionId, (AbstractAzResourceModule)service);
        this.subscriptionId = subscriptionId;
        this.clusterModule = new SpringCloudClusterModule(this);
    }

    SpringCloudServiceSubscription(@Nonnull AppPlatformManager remote, @Nonnull AzureSpringCloud service) {
        this(remote.subscriptionId(), service);
    }

    @Nonnull
    public List<AbstractAzResourceModule<?, ?, ?>> getSubModules() {
        return Collections.singletonList(this.clusterModule);
    }

    @Nonnull
    public SpringCloudClusterModule clusters() {
        return this.clusterModule;
    }

    @Nonnull
    public List<RuntimeVersion> listSupportedRuntimeVersions() {
        return ((AppPlatformManagementClient)Objects.requireNonNull((AppPlatformManager)this.getRemote()).serviceClient()).getRuntimeVersions().listRuntimeVersions().value().stream().filter(v -> v.platform() == SupportedRuntimePlatform.JAVA).map(SupportedRuntimeVersion::value).map(v -> RuntimeVersion.fromString((String)v.toString())).collect(Collectors.toList());
    }

    @Nonnull
    public List<Sku> listSupportedSkus(@Nullable Region region) {
        Stream<ResourceSku> skus = ((AppPlatformManagementClient)Objects.requireNonNull((AppPlatformManager)this.getRemote()).serviceClient()).getSkus().list().stream();
        if (Objects.nonNull(region)) {
            skus = skus.filter(s -> s.locations().contains(region.name()));
        }
        return skus.filter(s -> s.resourceType().equalsIgnoreCase("Spring")).map(sku -> new Sku(sku.name(), sku.tier())).distinct().sorted(Comparator.comparing(Sku::getOrdinal)).collect(Collectors.toList());
    }

    @Nonnull
    public List<Region> listSupportedRegions(@Nullable Sku sku) {
        Stream<ResourceSku> skus = ((AppPlatformManagementClient)Objects.requireNonNull((AppPlatformManager)this.getRemote()).serviceClient()).getSkus().list().stream();
        if (Objects.nonNull(sku)) {
            skus = skus.filter(s -> StringUtils.equalsIgnoreCase((CharSequence)sku.getName(), (CharSequence)s.name()) && StringUtils.equalsIgnoreCase((CharSequence)sku.getTier(), (CharSequence)s.tier()));
        }
        return skus.flatMap(s -> s.locations().stream().map(Region::fromName)).filter(Utils.distinctByKey(Region::name)).sorted(Comparator.comparing(Region::label)).collect(Collectors.toList());
    }

    @Nonnull
    @AzureOperation(name="azure/springcloud.check_name.name", params={"name"})
    public NameAvailability checkNameAvailability(Region region, String name) {
        Region region2 = region;
        String string = name;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this), (Object)region2, (Object)string);
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            NameAvailability nameAvailability = ((AppPlatformManagementClient)Objects.requireNonNull((AppPlatformManager)this.getRemote()).serviceClient()).getServices().checkNameAvailability(region.name(), new NameAvailabilityParameters().withName(name).withType(this.clusterModule.getFullResourceType()));
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return nameAvailability;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    @Nonnull
    public ResourceManager getResourceManager() {
        return Objects.requireNonNull((AppPlatformManager)this.getRemote()).resourceManager();
    }

    @Nonnull
    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    @Nonnull
    public SpringCloudClusterModule getClusterModule() {
        return this.clusterModule;
    }

    static {
        SpringCloudServiceSubscription.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("SpringCloudServiceSubscription.java", SpringCloudServiceSubscription.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "checkNameAvailability", "com.microsoft.azure.toolkit.lib.springcloud.SpringCloudServiceSubscription", "com.azure.core.management.Region:java.lang.String", "region:name", "", "com.azure.resourcemanager.appplatform.models.NameAvailability"), 100);
    }
}

