/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.springcloud;

import com.azure.resourcemanager.appplatform.models.PersistentDisk;
import com.azure.resourcemanager.appplatform.models.SpringApp;
import com.azure.resourcemanager.appplatform.models.SpringService;
import com.azure.resourcemanager.appplatform.models.TestKeys;
import com.azure.resourcemanager.resources.fluentcore.arm.models.HasParent;
import com.microsoft.azure.toolkit.lib.common.cache.Cache1;
import com.microsoft.azure.toolkit.lib.common.event.AzureEventBus;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResource;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResourceModule;
import com.microsoft.azure.toolkit.lib.common.model.Deletable;
import com.microsoft.azure.toolkit.lib.common.model.Startable;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperation;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperationAspect;
import com.microsoft.azure.toolkit.lib.springcloud.SpringCloudAppModule;
import com.microsoft.azure.toolkit.lib.springcloud.SpringCloudCluster;
import com.microsoft.azure.toolkit.lib.springcloud.SpringCloudDeployment;
import com.microsoft.azure.toolkit.lib.springcloud.SpringCloudDeploymentModule;
import com.microsoft.azure.toolkit.lib.springcloud.model.SpringCloudPersistentDisk;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public class SpringCloudApp
extends AbstractAzResource<SpringCloudApp, SpringCloudCluster, SpringApp>
implements Startable,
Deletable {
    @Nonnull
    private final SpringCloudDeploymentModule deploymentModule;
    @Nonnull
    private Cache1<SpringCloudDeployment> activeDeployment = new Cache1(() -> this.remoteOptional().map(SpringApp::activeDeploymentName).map(name -> (SpringCloudDeployment)this.deployments().get((String)name, this.getResourceGroupName())).orElse(null));
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;

    protected SpringCloudApp(@Nonnull String name, @Nonnull SpringCloudAppModule module) {
        super(name, (AbstractAzResourceModule)module);
        this.deploymentModule = new SpringCloudDeploymentModule(this);
    }

    protected SpringCloudApp(@Nonnull SpringCloudApp origin) {
        super((AbstractAzResource)origin);
        this.deploymentModule = origin.deploymentModule;
        this.activeDeployment = origin.activeDeployment;
    }

    protected SpringCloudApp(@Nonnull SpringApp remote, @Nonnull SpringCloudAppModule module) {
        super(remote.name(), (AbstractAzResourceModule)module);
        this.deploymentModule = new SpringCloudDeploymentModule(this);
    }

    public void invalidateCache() {
        super.invalidateCache();
        this.activeDeployment.invalidate();
    }

    protected void updateAdditionalProperties(SpringApp newRemote, SpringApp oldRemote) {
        super.updateAdditionalProperties((Object)newRemote, (Object)oldRemote);
        this.activeDeployment.get();
        AzureEventBus.emit((String)"resource.refreshed.resource", (Object)((Object)this));
    }

    @Nonnull
    public List<AbstractAzResourceModule<?, ?, ?>> getSubModules() {
        return Collections.singletonList(this.deploymentModule);
    }

    @Nonnull
    protected String loadStatus(@Nonnull SpringApp remote) {
        SpringCloudDeployment activeDeployment = this.getActiveDeployment();
        if (Objects.isNull((Object)activeDeployment)) {
            return "Inactive";
        }
        return activeDeployment.getStatus();
    }

    @Nonnull
    public SpringCloudDeploymentModule deployments() {
        return this.deploymentModule;
    }

    @AzureOperation(name="azure/resource.start_resource.resource", params={"this.name()"})
    public void start() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this));
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            this.doModify(() -> Objects.requireNonNull(this.getActiveDeployment()).start(), "Starting");
            this.refresh();
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    @AzureOperation(name="azure/resource.stop_resource.resource", params={"this.name()"})
    public void stop() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)((Object)this), (Object)((Object)this));
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            this.doModify(() -> Objects.requireNonNull(this.getActiveDeployment()).stop(), "Stopping");
            this.refresh();
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    @AzureOperation(name="azure/resource.restart_resource.resource", params={"this.name()"})
    public void restart() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)((Object)this), (Object)((Object)this));
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            this.doModify(() -> Objects.requireNonNull(this.getActiveDeployment()).restart(), "Restarting");
            this.refresh();
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    public boolean isPublicEndpointEnabled() {
        return this.remoteOptional().map(SpringApp::isPublic).orElse(false);
    }

    @Nullable
    public String getActiveDeploymentName() {
        return Optional.ofNullable(this.getActiveDeployment()).map(AbstractAzResource::getName).orElse(null);
    }

    @Nullable
    public SpringCloudDeployment getActiveDeployment() {
        return (SpringCloudDeployment)((Object)this.activeDeployment.get());
    }

    @Nullable
    public SpringCloudDeployment getCachedActiveDeployment() {
        return (SpringCloudDeployment)((Object)this.activeDeployment.getIfPresent());
    }

    @Nullable
    public String getApplicationUrl() {
        String url = Optional.ofNullable((SpringApp)this.getRemote()).map(SpringApp::url).orElse(null);
        return StringUtils.isBlank((CharSequence)url) || "None".equalsIgnoreCase(url) ? null : url;
    }

    @Nullable
    public String getTestUrl() {
        if (((SpringCloudCluster)this.getParent()).isConsumptionTier()) {
            return null;
        }
        String name = this.getActiveDeploymentName();
        if (Objects.isNull(name)) {
            return null;
        }
        return Optional.ofNullable(this.getTestEndpoint()).map(e -> String.format("%s/%s/%s", e, this.getName(), name)).orElse(null);
    }

    @Nullable
    public String getTestEndpoint() {
        return this.remoteOptional().map(HasParent::parent).map(SpringService::listTestKeys).map(TestKeys::primaryTestEndpoint).orElse(null);
    }

    @Nullable
    public SpringCloudPersistentDisk getPersistentDisk() {
        PersistentDisk disk = this.remoteOptional().map(SpringApp::persistentDisk).orElse(null);
        return Optional.ofNullable(disk).filter(d -> d.sizeInGB() > 0).map(d -> SpringCloudPersistentDisk.builder().sizeInGB(disk.sizeInGB()).mountPath(disk.mountPath()).usedInGB(disk.usedInGB()).build()).orElse(null);
    }

    public boolean isPersistentDiskEnabled() {
        return !((SpringCloudCluster)this.getParent()).isEnterpriseTier() && Objects.nonNull(this.getPersistentDisk());
    }

    @Nonnull
    public SpringCloudDeploymentModule getDeploymentModule() {
        return this.deploymentModule;
    }

    static {
        SpringCloudApp.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("SpringCloudApp.java", SpringCloudApp.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "start", "com.microsoft.azure.toolkit.lib.springcloud.SpringCloudApp", "", "", "", "void"), 96);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "stop", "com.microsoft.azure.toolkit.lib.springcloud.SpringCloudApp", "", "", "", "void"), 102);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "restart", "com.microsoft.azure.toolkit.lib.springcloud.SpringCloudApp", "", "", "", "void"), 108);
    }
}

