/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.resource;

import com.azure.core.management.Region;
import com.azure.resourcemanager.resources.ResourceManager;
import com.azure.resourcemanager.resources.models.Deployment;
import com.azure.resourcemanager.resources.models.DeploymentMode;
import com.microsoft.azure.toolkit.lib.common.bundle.AzureString;
import com.microsoft.azure.toolkit.lib.common.exception.AzureToolkitRuntimeException;
import com.microsoft.azure.toolkit.lib.common.messager.AzureMessager;
import com.microsoft.azure.toolkit.lib.common.messager.IAzureMessager;
import com.microsoft.azure.toolkit.lib.common.model.AzResource;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperation;
import com.microsoft.azure.toolkit.lib.resource.ResourceDeployment;
import com.microsoft.azure.toolkit.lib.resource.ResourceDeploymentModule;
import com.microsoft.azure.toolkit.lib.resource.ResourceGroup;
import com.microsoft.azure.toolkit.lib.resource.ResourceGroupManager;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class ResourceDeploymentDraft
extends ResourceDeployment
implements AzResource.Draft<ResourceDeployment, Deployment> {
    @Nullable
    private final ResourceDeployment origin;
    @Nullable
    private Config config;

    ResourceDeploymentDraft(@Nonnull String name, @Nonnull String resourceGroupName, @Nonnull ResourceDeploymentModule module) {
        super(name, resourceGroupName, module);
        this.origin = null;
    }

    ResourceDeploymentDraft(@Nonnull ResourceDeployment origin) {
        super(origin);
        this.origin = origin;
    }

    public void reset() {
        this.config = null;
    }

    @Nonnull
    @AzureOperation(name="resource.create_resource.resource|type", params={"this.getName()", "this.getResourceTypeName()"}, type=AzureOperation.Type.SERVICE)
    public Deployment createResourceInAzure() {
        ResourceGroup group = (ResourceGroup)this.getParent();
        String name = this.getName();
        String template = this.getTemplateAsJson();
        String parameters = this.getParametersAsJson();
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{name, template, parameters})) {
            throw new AzureToolkitRuntimeException("'name', 'template', 'parameters' are all required to create deployment.");
        }
        ResourceManager manager = Objects.requireNonNull((ResourceManager)((ResourceGroupManager)((ResourceGroup)this.getParent()).getParent()).getRemote());
        Deployment.DefinitionStages.Blank define = (Deployment.DefinitionStages.Blank)manager.deployments().define(name);
        Deployment.DefinitionStages.WithTemplate withTemplate = group.exists() ? (Deployment.DefinitionStages.WithTemplate)define.withExistingResourceGroup(group.getName()) : define.withNewResourceGroup(group.getName(), Region.fromName((String)group.getRegion().getName()));
        Deployment.DefinitionStages.WithCreate definition = withTemplate.withTemplate(template).withParameters(parameters).withMode(DeploymentMode.INCREMENTAL);
        IAzureMessager messager = AzureMessager.getMessager();
        messager.info(AzureString.format((String)"Start creating Deployment({0})...", (Object[])new Object[]{name}));
        Deployment deployment = (Deployment)definition.create();
        messager.success(AzureString.format((String)"Deployment({0}) is successfully created.", (Object[])new Object[]{name}));
        return deployment;
    }

    @Nonnull
    @AzureOperation(name="resource.update_resource.resource|type", params={"this.getName()", "this.getResourceTypeName()"}, type=AzureOperation.Type.SERVICE)
    public Deployment updateResourceInAzure(@Nonnull Deployment origin) {
        String name = this.getName();
        String oldTemplate = super.getTemplateAsJson();
        String oldParameters = super.getParametersAsJson();
        String newTemplate = this.getTemplateAsJson();
        String newParameters = this.getParametersAsJson();
        Deployment.Update update = (Deployment.Update)origin.update();
        boolean modified = false;
        if (!StringUtils.equals((CharSequence)newTemplate, (CharSequence)oldTemplate) || StringUtils.isNotBlank((CharSequence)newTemplate)) {
            update.withTemplate(oldTemplate);
        } else {
            modified = true;
            update.withTemplate(newTemplate);
        }
        if (!StringUtils.equals((CharSequence)newParameters, (CharSequence)oldParameters) && StringUtils.isNotBlank((CharSequence)newParameters)) {
            modified = true;
            update.withParameters(newParameters);
        }
        IAzureMessager messager = AzureMessager.getMessager();
        if (modified) {
            messager.info(AzureString.format((String)"Start updating Deployment({0})...", (Object[])new Object[]{name}));
            update.withMode(DeploymentMode.INCREMENTAL);
            origin = (Deployment)update.apply();
            messager.success(AzureString.format((String)"Deployment({0}) is successfully updated.", (Object[])new Object[]{name}));
        } else {
            messager.info(AzureString.format((String)"Nothing to update for {0}.", (Object[])new Object[]{name}));
        }
        return origin;
    }

    @Nonnull
    private synchronized Config ensureConfig() {
        this.config = Optional.ofNullable(this.config).orElseGet(Config::new);
        return this.config;
    }

    public void setTemplateAsJson(@Nonnull String template) {
        this.ensureConfig().setTemplateAsJson(template);
    }

    public void setParametersAsJson(@Nonnull String parameters) {
        this.ensureConfig().setParametersAsJson(parameters);
    }

    @Override
    @Nullable
    public String getTemplateAsJson() {
        return Optional.ofNullable(this.config).map(Config::getTemplateAsJson).orElseGet(() -> super.getTemplateAsJson());
    }

    @Override
    @Nullable
    public String getParametersAsJson() {
        return Optional.ofNullable(this.config).map(Config::getParametersAsJson).orElseGet(() -> super.getParametersAsJson());
    }

    public boolean isModified() {
        boolean notModified = Objects.isNull(this.config) || Objects.isNull(this.config.getTemplateAsJson()) || Objects.equals(this.config.getTemplateAsJson(), super.getTemplateAsJson()) || Objects.isNull(this.config.getParametersAsJson()) || Objects.equals(this.config.getParametersAsJson(), super.getParametersAsJson());
        return !notModified;
    }

    @Nullable
    public ResourceDeployment getOrigin() {
        return this.origin;
    }

    private static class Config {
        @Nullable
        private String templateAsJson;
        @Nullable
        private String parametersAsJson;

        @Nullable
        public String getTemplateAsJson() {
            return this.templateAsJson;
        }

        @Nullable
        public String getParametersAsJson() {
            return this.parametersAsJson;
        }

        public void setTemplateAsJson(@Nullable String templateAsJson) {
            this.templateAsJson = templateAsJson;
        }

        public void setParametersAsJson(@Nullable String parametersAsJson) {
            this.parametersAsJson = parametersAsJson;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Config)) {
                return false;
            }
            Config other = (Config)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$templateAsJson = this.getTemplateAsJson();
            String other$templateAsJson = other.getTemplateAsJson();
            if (this$templateAsJson == null ? other$templateAsJson != null : !this$templateAsJson.equals(other$templateAsJson)) {
                return false;
            }
            String this$parametersAsJson = this.getParametersAsJson();
            String other$parametersAsJson = other.getParametersAsJson();
            return !(this$parametersAsJson == null ? other$parametersAsJson != null : !this$parametersAsJson.equals(other$parametersAsJson));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Config;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $templateAsJson = this.getTemplateAsJson();
            result = result * 59 + ($templateAsJson == null ? 43 : $templateAsJson.hashCode());
            String $parametersAsJson = this.getParametersAsJson();
            result = result * 59 + ($parametersAsJson == null ? 43 : $parametersAsJson.hashCode());
            return result;
        }

        public String toString() {
            return "ResourceDeploymentDraft.Config(templateAsJson=" + this.getTemplateAsJson() + ", parametersAsJson=" + this.getParametersAsJson() + ")";
        }
    }
}

