/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.containerregistry;

import com.azure.containers.containerregistry.ContainerRegistryClient;
import com.azure.containers.containerregistry.ContainerRegistryClientBuilder;
import com.azure.containers.containerregistry.ContainerRepository;
import com.azure.containers.containerregistry.models.ContainerRegistryAudience;
import com.azure.core.management.AzureEnvironment;
import com.azure.core.util.paging.ContinuablePage;
import com.microsoft.azure.toolkit.lib.Azure;
import com.microsoft.azure.toolkit.lib.auth.Account;
import com.microsoft.azure.toolkit.lib.auth.AzureAccount;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResourceModule;
import com.microsoft.azure.toolkit.lib.common.model.AzResource;
import com.microsoft.azure.toolkit.lib.common.model.page.ItemPage;
import com.microsoft.azure.toolkit.lib.containerregistry.ContainerRegistry;
import com.microsoft.azure.toolkit.lib.containerregistry.Repository;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class RepositoryModule
extends AbstractAzResourceModule<Repository, ContainerRegistry, ContainerRepository> {
    public static final String NAME = "repositories";
    @Nullable
    private ContainerRegistryClient client;

    public RepositoryModule(@Nonnull ContainerRegistry parent) {
        super(NAME, (AzResource)parent);
    }

    protected void invalidateCache() {
        super.invalidateCache();
        this.client = null;
    }

    public ContainerRegistryClient getClient() {
        if (Objects.isNull(this.client) && ((ContainerRegistry)this.parent).exists()) {
            String endpoint = String.format("https://%s", ((ContainerRegistry)this.getParent()).getLoginServerUrl());
            Account account = ((AzureAccount)Azure.az(AzureAccount.class)).account();
            this.client = new ContainerRegistryClientBuilder().endpoint(endpoint).audience(RepositoryModule.getAudience()).credential(account.getTokenCredential(this.getSubscriptionId())).buildClient();
        }
        return this.client;
    }

    @Nonnull
    protected Iterator<? extends ContinuablePage<String, ContainerRepository>> loadResourcePagesFromAzure() {
        if (!((ContainerRegistry)this.parent).exists()) {
            return Collections.emptyIterator();
        }
        ContainerRegistryClient client = this.getClient();
        if (Objects.nonNull(client)) {
            return client.listRepositoryNames().streamByPage(RepositoryModule.getPageSize()).map(p -> p.getValue().stream().map(arg_0 -> ((ContainerRegistryClient)client).getRepository(arg_0))).map(ItemPage::new).iterator();
        }
        return Collections.emptyIterator();
    }

    @Nullable
    protected ContainerRepository loadResourceFromAzure(@Nonnull String name, String resourceGroup) {
        if (!((ContainerRegistry)this.parent).exists()) {
            return null;
        }
        ContainerRegistryClient client = this.getClient();
        return Objects.requireNonNull(client).getRepository(name);
    }

    protected void deleteResourceFromAzure(@Nonnull String resourceId) {
        Repository repository = (Repository)this.get(resourceId);
        if (!((ContainerRegistry)this.parent).exists() || Objects.isNull((Object)repository)) {
            return;
        }
        ContainerRegistryClient client = this.getClient();
        Objects.requireNonNull(client).deleteRepository(repository.getName());
    }

    @Nonnull
    protected Repository newResource(@Nonnull ContainerRepository repository) {
        return new Repository(repository.getName(), this);
    }

    @Nonnull
    protected Repository newResource(@Nonnull String name, @Nullable String resourceGroupName) {
        return new Repository(name, this);
    }

    private static ContainerRegistryAudience getAudience() {
        Account account = ((AzureAccount)Azure.az(AzureAccount.class)).account();
        AzureEnvironment env = account.getEnvironment();
        if (env.getPortal().equalsIgnoreCase(AzureEnvironment.AZURE_CHINA.getPortal())) {
            return ContainerRegistryAudience.AZURE_RESOURCE_MANAGER_CHINA;
        }
        if (env.getPortal().equalsIgnoreCase(AzureEnvironment.AZURE_GERMANY.getPortal())) {
            return ContainerRegistryAudience.AZURE_RESOURCE_MANAGER_GERMANY;
        }
        if (env.getPortal().equalsIgnoreCase(AzureEnvironment.AZURE_US_GOVERNMENT.getPortal())) {
            return ContainerRegistryAudience.AZURE_RESOURCE_MANAGER_GOVERNMENT;
        }
        return ContainerRegistryAudience.AZURE_RESOURCE_MANAGER_PUBLIC_CLOUD;
    }

    @Nonnull
    public String getResourceTypeName() {
        return "Repository";
    }
}

