/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.containerapps.environment;

import com.azure.core.util.ExpandableStringEnum;
import com.azure.resourcemanager.appcontainers.ContainerAppsApiManager;
import com.azure.resourcemanager.appcontainers.models.CheckNameAvailabilityRequest;
import com.azure.resourcemanager.appcontainers.models.CheckNameAvailabilityResponse;
import com.azure.resourcemanager.appcontainers.models.ManagedEnvironment;
import com.azure.resourcemanager.resources.fluentcore.arm.ResourceId;
import com.microsoft.azure.toolkit.lib.Azure;
import com.microsoft.azure.toolkit.lib.common.bundle.AzureString;
import com.microsoft.azure.toolkit.lib.common.exception.AzureToolkitRuntimeException;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResource;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResourceModule;
import com.microsoft.azure.toolkit.lib.common.model.Availability;
import com.microsoft.azure.toolkit.lib.common.model.Deletable;
import com.microsoft.azure.toolkit.lib.common.model.Region;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperation;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperationAspect;
import com.microsoft.azure.toolkit.lib.common.utils.StreamingLogSupport;
import com.microsoft.azure.toolkit.lib.containerapps.AzureContainerApps;
import com.microsoft.azure.toolkit.lib.containerapps.AzureContainerAppsServiceSubscription;
import com.microsoft.azure.toolkit.lib.containerapps.containerapp.ContainerApp;
import com.microsoft.azure.toolkit.lib.containerapps.environment.ContainerAppsEnvironmentModule;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public class ContainerAppsEnvironment
extends AbstractAzResource<ContainerAppsEnvironment, AzureContainerAppsServiceSubscription, ManagedEnvironment>
implements Deletable,
StreamingLogSupport {
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    protected ContainerAppsEnvironment(@Nonnull String name, @Nonnull String resourceGroupName, @Nonnull ContainerAppsEnvironmentModule module) {
        super(name, resourceGroupName, (AbstractAzResourceModule)module);
    }

    public void refresh() {
        ((AzureContainerApps)Azure.az(AzureContainerApps.class)).containerApps(this.getSubscriptionId()).refresh();
        super.refresh();
    }

    protected ContainerAppsEnvironment(@Nonnull ContainerAppsEnvironment insight) {
        super((AbstractAzResource)insight);
    }

    protected ContainerAppsEnvironment(@Nonnull ManagedEnvironment remote, @Nonnull ContainerAppsEnvironmentModule module) {
        super(remote.name(), ResourceId.fromString((String)remote.id()).resourceGroupName(), (AbstractAzResourceModule)module);
    }

    public List<ContainerApp> listContainerApps() {
        return ((AzureContainerApps)Azure.az(AzureContainerApps.class)).containerApps(this.getSubscriptionId()).listContainerAppsByEnvironment(this);
    }

    @Nullable
    public Region getRegion() {
        return Optional.ofNullable((ManagedEnvironment)this.getRemote()).map(remote -> Region.fromName((String)remote.region().name())).orElse(null);
    }

    @AzureOperation(name="azure/containerapps.check_name.name", params={"name"})
    public Availability checkContainerAppNameAvailability(String name) {
        String string = name;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this), (Object)string);
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            CheckNameAvailabilityRequest request = new CheckNameAvailabilityRequest().withName(name).withType("Microsoft.App/containerApps");
            CheckNameAvailabilityResponse result = Objects.requireNonNull((ContainerAppsApiManager)((AzureContainerAppsServiceSubscription)this.getModule().getParent()).getRemote()).namespaces().checkNameAvailability(this.getResourceGroupName(), this.getName(), request);
            Availability availability = new Availability(result.nameAvailable().booleanValue(), (String)Optional.ofNullable(result.reason()).map(ExpandableStringEnum::toString).orElse(null), result.message());
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return availability;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    @Nonnull
    public List<AbstractAzResourceModule<?, ?, ?>> getSubModules() {
        return Collections.emptyList();
    }

    @Nonnull
    protected String loadStatus(@Nonnull ManagedEnvironment remote) {
        return remote.provisioningState().toString();
    }

    public String getLogStreamEndpoint() {
        ManagedEnvironment remoteEnv = (ManagedEnvironment)this.getRemote();
        if (Objects.isNull(remoteEnv)) {
            throw new AzureToolkitRuntimeException(AzureString.format((String)"resource ({0}) not found", (Object[])new Object[]{this.getName()}).toString());
        }
        String baseUrl = String.format("https://%s.azurecontainerapps.dev", remoteEnv.location());
        return String.format("%s/subscriptions/%s/resourceGroups/%s/managedEnvironments/%s/eventstream", baseUrl, this.getSubscriptionId(), this.getResourceGroupName(), this.getName());
    }

    public String getLogStreamAuthorization() {
        ContainerAppsApiManager manager = (ContainerAppsApiManager)((AzureContainerAppsServiceSubscription)this.getParent()).getRemote();
        String authToken = Optional.ofNullable(manager).map(m -> m.managedEnvironments().getAuthToken(this.getResourceGroupName(), this.getName()).token()).orElse(null);
        return "Bearer " + authToken;
    }

    static {
        ContainerAppsEnvironment.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("ContainerAppsEnvironment.java", ContainerAppsEnvironment.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "checkContainerAppNameAvailability", "com.microsoft.azure.toolkit.lib.containerapps.environment.ContainerAppsEnvironment", "java.lang.String", "name", "", "com.microsoft.azure.toolkit.lib.common.model.Availability"), 59);
    }
}

