/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.common.operation;

import com.microsoft.azure.toolkit.lib.common.bundle.AzureString;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperation;
import com.microsoft.azure.toolkit.lib.common.operation.OperationBase;
import com.microsoft.azure.toolkit.lib.common.operation.OperationBundle;
import com.microsoft.azure.toolkit.lib.common.utils.aspect.ExpressionUtils;
import com.microsoft.azure.toolkit.lib.common.utils.aspect.MethodInvocation;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.Callable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class MethodOperation
extends OperationBase {
    private final MethodInvocation invocation;
    private Object source;

    public String toString() {
        AzureOperation annotation = this.invocation.getAnnotation(AzureOperation.class);
        String name = (String)StringUtils.firstNonBlank((CharSequence[])new String[]{annotation.name(), annotation.value()});
        return String.format("{name:'%s', method:%s}", name, this.invocation.getMethod().getName());
    }

    @Override
    @Nonnull
    public String getId() {
        AzureOperation annotation = this.invocation.getAnnotation(AzureOperation.class);
        return (String)StringUtils.firstNonBlank((CharSequence[])new String[]{annotation.name(), annotation.value()});
    }

    public Callable<Object> getBody() {
        return this.invocation::invoke;
    }

    @Override
    @Nullable
    public Object getSource() {
        if (Objects.isNull(this.source)) {
            AzureOperation annotation = this.invocation.getAnnotation(AzureOperation.class);
            String sourceExpression = annotation.source();
            this.source = StringUtils.isNotBlank((CharSequence)sourceExpression) ? ExpressionUtils.evaluate(sourceExpression, this.invocation) : this.invocation.getInstance();
        }
        return this.source;
    }

    @Override
    public AzureString getDescription() {
        AzureOperation annotation = this.invocation.getAnnotation(AzureOperation.class);
        String name = (String)StringUtils.firstNonBlank((CharSequence[])new String[]{annotation.name(), annotation.value()});
        String[] params = (String[])Arrays.stream(annotation.params()).map(e -> ExpressionUtils.interpret(e, this.invocation)).toArray(String[]::new);
        return OperationBundle.description(name, params);
    }

    public MethodInvocation getInvocation() {
        return this.invocation;
    }

    public MethodOperation(MethodInvocation invocation) {
        this.invocation = invocation;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MethodOperation)) {
            return false;
        }
        MethodOperation other = (MethodOperation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        MethodInvocation this$invocation = this.getInvocation();
        MethodInvocation other$invocation = other.getInvocation();
        return !(this$invocation == null ? other$invocation != null : !((Object)this$invocation).equals(other$invocation));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MethodOperation;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        MethodInvocation $invocation = this.getInvocation();
        result = result * 59 + ($invocation == null ? 43 : ((Object)$invocation).hashCode());
        return result;
    }
}

