/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.common.utils;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.PumpStreamHandler;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandUtils {
    private static final Logger log = LoggerFactory.getLogger(CommandUtils.class);
    private static final String WINDOWS_STARTER = "cmd.exe";
    private static final String LINUX_MAC_STARTER = "/bin/sh";
    private static final String WINDOWS_SWITCHER = "/c";
    private static final String LINUX_MAC_SWITCHER = "-c";
    private static final String DEFAULT_WINDOWS_SYSTEM_ROOT = System.getenv("SystemRoot");
    private static final String DEFAULT_MAC_LINUX_PATH = "/bin/";
    private static final Map<String, String> ENV = new HashMap<String, String>(System.getenv());

    public static void setEnv(Map<String, String> env) {
        ENV.clear();
        ENV.putAll(env);
    }

    public static List<String> resolveCommandPath(String command) {
        ArrayList<String> list = new ArrayList<String>();
        try {
            String output = CommandUtils.exec((CommandUtils.isWindows() ? "where " : "which ") + command);
            if (StringUtils.isBlank((CharSequence)output)) {
                return Collections.emptyList();
            }
            for (String outputLine : output.split("[\\r\\n]")) {
                File file = new File(StringUtils.trim((String)outputLine));
                if (!file.exists() || !file.isFile()) continue;
                list.add(file.getAbsolutePath());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return list;
    }

    public static String exec(String commandWithArgs) throws IOException {
        return CommandUtils.exec(commandWithArgs, new HashMap<String, String>());
    }

    public static String exec(String commandWithArgs, String cwd) throws IOException {
        return CommandUtils.exec(commandWithArgs, new HashMap<String, String>(), cwd);
    }

    public static String exec(String commandWithArgs, Map<String, String> env) throws IOException {
        return CommandUtils.exec(commandWithArgs, env, null);
    }

    public static String exec(String commandWithArgs, Map<String, String> env, String cwd) throws IOException {
        return CommandUtils.exec(commandWithArgs, env, cwd, false);
    }

    public static String exec(String commandWithArgs, String cwd, boolean mergeErrorStream) throws IOException {
        return CommandUtils.exec(commandWithArgs, new HashMap<String, String>(), cwd, mergeErrorStream);
    }

    public static String exec(String commandWithArgs, Map<String, String> env, String cwd, boolean mergeErrorStream) throws IOException {
        String starter = CommandUtils.isWindows() ? WINDOWS_STARTER : LINUX_MAC_STARTER;
        String switcher = CommandUtils.isWindows() ? WINDOWS_SWITCHER : LINUX_MAC_SWITCHER;
        String workingDirectory = (String)StringUtils.firstNonBlank((CharSequence[])new String[]{cwd, CommandUtils.getSafeWorkingDirectory()});
        if (StringUtils.isEmpty((CharSequence)workingDirectory)) {
            IllegalStateException exception = new IllegalStateException("A Safe Working directory could not be found to execute command from.");
            log.error(CommandUtils.class.getName(), (Object)"exec", (Object)exception);
            throw exception;
        }
        return CommandUtils.executeCommandAndGetOutput(starter, switcher, commandWithArgs, new File(workingDirectory), env, mergeErrorStream);
    }

    private static String executeCommandAndGetOutput(String starter, String switcher, String commandWithArgs, File directory, Map<String, String> env, boolean mergeErrorStream) throws IOException {
        CommandLine commandLine = new CommandLine(starter);
        commandLine.addArgument(switcher, false);
        commandLine.addArgument(commandWithArgs, false);
        return CommandUtils.executeCommandAndGetOutput(commandLine, directory, env, mergeErrorStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String executeCommandAndGetOutput(CommandLine commandLine, File directory, Map<String, String> env, boolean mergeErrorStream) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ByteArrayOutputStream err = mergeErrorStream ? out : new ByteArrayOutputStream();
        PumpStreamHandler streamHandler = new PumpStreamHandler((OutputStream)out, (OutputStream)err);
        DefaultExecutor executor = new DefaultExecutor();
        executor.setWorkingDirectory(directory);
        executor.setStreamHandler((ExecuteStreamHandler)streamHandler);
        executor.setExitValues(new int[]{0});
        try {
            HashMap<String, String> newEnv = new HashMap<String, String>(ENV);
            if (env != null) {
                newEnv.putAll(env);
            }
            executor.execute(commandLine, newEnv);
            String result = StringUtils.trimToEmpty((String)out.toString());
            if (!mergeErrorStream && err.size() > 0 && StringUtils.isEmpty((CharSequence)result)) {
                throw new IOException(StringUtils.trim((String)err.toString()));
            }
            String string = result;
            return string;
        }
        finally {
            out.close();
            err.close();
        }
    }

    public static boolean isWindows() {
        return SystemUtils.IS_OS_WINDOWS;
    }

    public static boolean isWSL() {
        return SystemUtils.IS_OS_LINUX && System.getenv("WSL_DISTRO_NAME") != null;
    }

    private static String getSafeWorkingDirectory() {
        if (CommandUtils.isWindows()) {
            if (StringUtils.isEmpty((CharSequence)DEFAULT_WINDOWS_SYSTEM_ROOT)) {
                return null;
            }
            return DEFAULT_WINDOWS_SYSTEM_ROOT + "\\system32";
        }
        return DEFAULT_MAC_LINUX_PATH;
    }
}

