/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.common.action;

import com.microsoft.azure.toolkit.lib.common.action.AzureActionManager;
import com.microsoft.azure.toolkit.lib.common.bundle.AzureString;
import com.microsoft.azure.toolkit.lib.common.exception.AzureToolkitRuntimeException;
import com.microsoft.azure.toolkit.lib.common.model.AzResource;
import com.microsoft.azure.toolkit.lib.common.model.AzResourceModule;
import com.microsoft.azure.toolkit.lib.common.model.Emulatable;
import com.microsoft.azure.toolkit.lib.common.operation.Operation;
import com.microsoft.azure.toolkit.lib.common.operation.OperationBase;
import com.microsoft.azure.toolkit.lib.common.operation.OperationBundle;
import com.microsoft.azure.toolkit.lib.common.operation.OperationContext;
import com.microsoft.azure.toolkit.lib.common.task.AzureTaskManager;
import com.microsoft.azure.toolkit.lib.common.view.IView;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.PropertyKey;

public class Action<D>
extends OperationBase
implements Cloneable {
    public static final String SOURCE = "ACTION_SOURCE";
    public static final String PLACE = "action_place";
    public static final String EMPTY_PLACE = "empty";
    public static final String RESOURCE_TYPE = "resourceType";
    public static final Id<Runnable> REQUIRE_AUTH = Id.of("common.requireAuth");
    public static final Id<Object> AUTHENTICATE = Id.of("user/account.authenticate");
    public static final Id<Object> OPEN_AZURE_SETTINGS = Id.of("user/common.open_azure_settings");
    public static final Id<Object> DISABLE_AUTH_CACHE = Id.of("user/account.disable_auth_cache");
    public static final String COMMON = "common";
    @Nonnull
    private final Id<D> id;
    @Nonnull
    private Predicate<D> enableWhen = o -> true;
    private BiPredicate<Object, String> visibleWhen = (o, place) -> true;
    private Function<D, String> iconProvider;
    private Function<D, String> labelProvider;
    private Function<D, AzureString> titleProvider;
    @Nonnull
    private List<Pair<BiPredicate<D, ?>, BiConsumer<D, ?>>> handlers = new ArrayList();
    @Nonnull
    private List<Function<D, String>> titleParamProviders = new ArrayList<Function<D, String>>();
    private D source;
    private String place;
    private Predicate<D> authRequiredProvider = Action::isAuthRequiredForAzureResource;
    private Object shortcut;

    public Action(@Nonnull Id<D> id) {
        this.id = id;
    }

    @Override
    @Nonnull
    public String getId() {
        return ((Id)this.id).id;
    }

    public IView.Label getView(D s) {
        return this.getView(s, COMMON);
    }

    @Nonnull
    public IView.Label getView(D s, String place) {
        Object source = Optional.ofNullable(this.source).orElse(s);
        try {
            boolean visible = this.visibleWhen.test(source, place);
            if (visible) {
                String label = this.labelProvider.apply(source);
                String icon = Optional.ofNullable(this.iconProvider).map(p -> (String)p.apply(source)).orElse(null);
                boolean enabled = this.enableWhen.test(source);
                AzureString title = this.getTitle(source);
                return new View(label, icon, enabled, title);
            }
            return View.INVISIBLE;
        }
        catch (Exception e) {
            e.printStackTrace();
            return View.INVISIBLE;
        }
    }

    @Nullable
    public BiConsumer<D, Object> getHandler(D s, Object e) {
        D source = Optional.ofNullable(this.source).orElse(s);
        if (!this.visibleWhen.test(source, COMMON) && !this.enableWhen.test(source)) {
            return null;
        }
        for (int i = this.handlers.size() - 1; i >= 0; --i) {
            Pair<BiPredicate<D, ?>, BiConsumer<D, ?>> p = this.handlers.get(i);
            BiPredicate condition = (BiPredicate)p.getKey();
            BiConsumer handler = (BiConsumer)p.getValue();
            if (!condition.test(source, e)) continue;
            return handler;
        }
        return null;
    }

    public void handle(D s, Object e) {
        Object source = Optional.ofNullable(this.source).orElse(s);
        BiConsumer<D, Object> handler = this.getHandler(source, e);
        if (Objects.isNull(handler)) {
            return;
        }
        AzureString title = this.getTitle(source);
        Runnable operationBody = () -> AzureTaskManager.getInstance().runInBackground(title, () -> this.handle(source, e, handler));
        Runnable handlerBody = () -> Operation.execute(title, "user", operationBody, source);
        if (this.isAuthRequired(s)) {
            Action<Runnable> requireAuth = AzureActionManager.getInstance().getAction(REQUIRE_AUTH);
            if (Objects.nonNull(requireAuth)) {
                requireAuth.handle(handlerBody, e);
            }
        } else {
            handlerBody.run();
        }
    }

    private void handle(D s, Object e, BiConsumer<D, Object> handler) {
        D source = Optional.ofNullable(this.source).orElse(s);
        OperationContext context = OperationContext.action();
        context.setTelemetryProperties(this.getContext().getTelemetryProperties());
        if (source instanceof AzResource) {
            AzResource resource = (AzResource)source;
            context.setTelemetryProperty("subscriptionId", resource.getSubscriptionId());
            context.setTelemetryProperty(RESOURCE_TYPE, resource.getFullResourceType());
        } else if (source instanceof AzResourceModule) {
            AzResourceModule resource = (AzResourceModule)source;
            context.setTelemetryProperty("subscriptionId", resource.getSubscriptionId());
            context.setTelemetryProperty(RESOURCE_TYPE, resource.getFullResourceType());
        }
        handler.accept(source, e);
    }

    public void handle(D s) {
        D source = Optional.ofNullable(this.source).orElse(s);
        this.handle(source, null);
    }

    @Override
    public Callable<?> getBody() {
        throw new AzureToolkitRuntimeException("'action.getBody()' is not supported");
    }

    @Override
    @Nonnull
    public String getType() {
        return "user";
    }

    private boolean isAuthRequired(D s) {
        Object source = Optional.ofNullable(this.source).orElse(s);
        return Optional.ofNullable(this.authRequiredProvider).map(p -> p.test(source)).orElse(true);
    }

    public AzureString getTitle(D s) {
        Object source = Optional.ofNullable(this.source).orElse(s);
        if (Objects.nonNull(this.titleProvider)) {
            return this.titleProvider.apply(source);
        }
        if (!this.titleParamProviders.isEmpty()) {
            Object[] params = this.titleParamProviders.stream().map(p -> (String)p.apply(source)).toArray();
            return OperationBundle.description(((Id)this.id).id, params);
        }
        return this.getDescription();
    }

    @Override
    @Nonnull
    public AzureString getDescription() {
        return OperationBundle.description(((Id)this.id).id, new Object[0]);
    }

    public Action<D> enableWhen(@Nonnull Predicate<D> enableWhen) {
        this.enableWhen = enableWhen;
        return this;
    }

    public Action<D> visibleWhen(@Nonnull Predicate<Object> visibleWhen) {
        this.visibleWhen = (object, ignore) -> visibleWhen.test(object);
        return this;
    }

    public Action<D> visibleWhen(@Nonnull BiPredicate<Object, String> visibleWhen) {
        this.visibleWhen = visibleWhen;
        return this;
    }

    public Action<D> withLabel(@Nonnull String label) {
        this.labelProvider = any -> label;
        return this;
    }

    public Action<D> withLabel(@Nonnull Function<D, String> labelProvider) {
        this.labelProvider = labelProvider;
        return this;
    }

    public Action<D> withIcon(@Nonnull String icon) {
        this.iconProvider = any -> icon;
        return this;
    }

    public Action<D> withIcon(@Nonnull Function<D, String> iconProvider) {
        this.iconProvider = iconProvider;
        return this;
    }

    public Action<D> withTitle(@Nonnull AzureString title) {
        this.titleProvider = any -> title;
        return this;
    }

    public Action<D> withShortcut(@Nonnull Object shortcut) {
        this.shortcut = shortcut;
        return this;
    }

    public Action<D> withHandler(@Nonnull Consumer<D> handler) {
        this.handlers.add(Pair.of((d, e) -> true, (d, e) -> handler.accept(d)));
        return this;
    }

    public <E> Action<D> withHandler(@Nonnull BiConsumer<D, E> handler) {
        this.handlers.add(Pair.of((d, e) -> true, handler));
        return this;
    }

    public Action<D> withHandler(@Nonnull Predicate<D> condition, @Nonnull Consumer<D> handler) {
        this.handlers.add(Pair.of((d, e) -> condition.test(d), (d, e) -> handler.accept(d)));
        return this;
    }

    public <E> Action<D> withHandler(@Nonnull BiPredicate<D, E> condition, @Nonnull BiConsumer<D, E> handler) {
        this.handlers.add(Pair.of(condition, handler));
        return this;
    }

    public Action<D> withAuthRequired(boolean authRequired) {
        this.authRequiredProvider = ignore -> authRequired;
        return this;
    }

    public Action<D> withAuthRequired(@Nonnull Predicate<D> authRequiredProvider) {
        this.authRequiredProvider = authRequiredProvider;
        return this;
    }

    public Action<D> withIdParam(@Nonnull String titleParam) {
        this.titleParamProviders.add(d -> titleParam);
        return this;
    }

    public Action<D> withIdParam(@Nonnull Function<D, String> titleParamProvider) {
        this.titleParamProviders.add(titleParamProvider);
        return this;
    }

    public Action<D> bind(D source) {
        try {
            Action clone = (Action)this.clone();
            clone.handlers = new ArrayList(this.handlers);
            clone.titleParamProviders = new ArrayList<Function<D, String>>(this.titleParamProviders);
            clone.source = source;
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public void register(AzureActionManager am) {
        am.registerAction(this);
    }

    public String toString() {
        return String.format("Action {id:'%s', bindTo: %s}", this.getId(), this.source);
    }

    public static Action<Void> retryFromFailure(@Nonnull Runnable handler) {
        return new Action<Void>(Id.of("common.retry")).withHandler((D v) -> handler.run()).withLabel("Retry");
    }

    public static <D> Boolean isAuthRequiredForAzureResource(@Nullable D resource) {
        return !(resource instanceof Emulatable) || !((Emulatable)resource).isEmulatorResource();
    }

    public Action<D> setAuthRequiredProvider(Predicate<D> authRequiredProvider) {
        this.authRequiredProvider = authRequiredProvider;
        return this;
    }

    public Action<D> setShortcut(Object shortcut) {
        this.shortcut = shortcut;
        return this;
    }

    public Object getShortcut() {
        return this.shortcut;
    }

    public static class View
    implements IView.Label {
        public static View INVISIBLE = new View("", "", false, false, null);
        @Nonnull
        private final String label;
        private final String iconPath;
        private final boolean enabled;
        private boolean visible = true;
        @Nullable
        private AzureString title;

        public View(@Nonnull String label, String iconPath, boolean enabled, @Nullable AzureString title) {
            this(label, iconPath, enabled, true, title);
        }

        @Override
        public String getDescription() {
            return Optional.ofNullable(this.title).map(AzureString::toString).orElse(null);
        }

        @Override
        public void dispose() {
        }

        @Override
        @Nonnull
        public String getLabel() {
            return this.label;
        }

        @Override
        public String getIconPath() {
            return this.iconPath;
        }

        @Override
        public boolean isEnabled() {
            return this.enabled;
        }

        @Override
        public boolean isVisible() {
            return this.visible;
        }

        @Nullable
        public AzureString getTitle() {
            return this.title;
        }

        public View(@Nonnull String label, String iconPath, boolean enabled) {
            if (label == null) {
                throw new NullPointerException("label is marked non-null but is null");
            }
            this.label = label;
            this.iconPath = iconPath;
            this.enabled = enabled;
        }

        public View(@Nonnull String label, String iconPath, boolean enabled, boolean visible, @Nullable AzureString title) {
            if (label == null) {
                throw new NullPointerException("label is marked non-null but is null");
            }
            this.label = label;
            this.iconPath = iconPath;
            this.enabled = enabled;
            this.visible = visible;
            this.title = title;
        }
    }

    public static class Id<D> {
        @Nonnull
        private final String id;

        private Id(@Nonnull String id) {
            this.id = id;
        }

        public static <D> Id<D> of(@Nonnull @PropertyKey(resourceBundle="bundles.com.microsoft.azure.toolkit.operation") @PropertyKey(resourceBundle="bundles.com.microsoft.azure.toolkit.operation") String id) {
            assert (StringUtils.isNotBlank((CharSequence)id)) : "action id can not be blank";
            return new Id<D>(id);
        }

        @Nonnull
        public String getId() {
            return this.id;
        }
    }
}

