/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.common.utils;

import com.microsoft.azure.toolkit.lib.common.exception.AzureToolkitRuntimeException;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.util.Map;
import java.util.Objects;
import org.apache.http.client.utils.URIBuilder;
import reactor.core.publisher.Flux;

public interface StreamingLogSupport {
    default public Flux<String> streamingLogs(String endPoint, Map<String, String> params) {
        if (Objects.isNull(endPoint)) {
            return Flux.empty();
        }
        try {
            URIBuilder uriBuilder = new URIBuilder(endPoint);
            params.forEach((arg_0, arg_1) -> ((URIBuilder)uriBuilder).addParameter(arg_0, arg_1));
            HttpURLConnection connection = (HttpURLConnection)uriBuilder.build().toURL().openConnection();
            connection.setRequestProperty("Authorization", this.getAuthorizationValue());
            connection.setReadTimeout(600000);
            connection.setConnectTimeout(3000);
            connection.setRequestMethod("GET");
            connection.connect();
            return Flux.create(fluxSink -> {
                try {
                    String line;
                    InputStream is = connection.getInputStream();
                    BufferedReader rd = new BufferedReader(new InputStreamReader(is));
                    while ((line = rd.readLine()) != null) {
                        fluxSink.next((Object)line);
                    }
                    rd.close();
                }
                catch (Exception e) {
                    throw new AzureToolkitRuntimeException(e);
                }
            });
        }
        catch (Exception e) {
            throw new AzureToolkitRuntimeException(e);
        }
    }

    default public String getAuthorizationValue() {
        return "";
    }
}

