/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.common.telemetry;

import com.microsoft.azure.toolkit.lib.common.operation.MethodOperation;
import com.microsoft.azure.toolkit.lib.common.operation.Operation;
import com.microsoft.azure.toolkit.lib.common.operation.OperationContext;
import com.microsoft.azure.toolkit.lib.common.telemetry.AzureTelemetry;
import com.microsoft.azure.toolkit.lib.common.telemetry.AzureTelemetryClient;
import java.lang.reflect.Parameter;
import java.time.Instant;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.tuple.Triple;

public class AzureTelemeter {
    public static final String SERVICE_NAME = "serviceName";
    public static final String OPERATION_NAME = "operationName";
    public static final String OP_ID = "op_id";
    public static final String OP_NAME = "op_name";
    public static final String OP_TYPE = "op_type";
    public static final String OP_PARENT_ID = "op_parentId";
    public static final String ERROR_CODE = "error.error_code";
    public static final String ERROR_MSG = "error.error_msg";
    public static final String ERROR_ROOT_MSG = "error.root_error_message";
    public static final String ERROR_TYPE = "error.error_type";
    public static final String ERROR_CLASSNAME = "error.error_class_name";
    public static final String ERROR_ROOT_CLASSNAME = "error.root_error_class_name";
    public static final String ERROR_STACKTRACE = "error.error_stack_trace";
    @Nullable
    private static String eventNamePrefix;
    @Nullable
    private static AzureTelemetryClient client;

    @Nullable
    public static Map<String, String> getCommonProperties() {
        return Optional.ofNullable(client).map(AzureTelemetryClient::getDefaultProperties).orElse(null);
    }

    public static void setCommonProperties(@Nullable Map<String, String> commonProperties) {
        Optional.ofNullable(AzureTelemeter.client).ifPresent(client -> client.setDefaultProperties(commonProperties));
    }

    public static void afterCreate(@Nonnull Operation op) {
        op.getContext().setTelemetryProperty("op_create_at", Instant.now().toString());
    }

    public static void beforeEnter(@Nonnull Operation op) {
        op.getContext().setTelemetryProperty("op_enter_at", Instant.now().toString());
    }

    public static void afterExit(@Nonnull Operation op) {
        op.getContext().setTelemetryProperty("op_exit_at", Instant.now().toString());
        AzureTelemeter.log(AzureTelemetry.Type.OP_END, AzureTelemeter.serialize(op));
    }

    public static void onError(@Nonnull Operation op, Throwable error) {
        op.getContext().setTelemetryProperty("op_exit_at", Instant.now().toString());
        AzureTelemeter.log(AzureTelemetry.Type.ERROR, AzureTelemeter.serialize(op), error);
    }

    public static void log(AzureTelemetry.Type type, Map<String, String> properties, Throwable e) {
        if (Objects.nonNull(e)) {
            properties.putAll(AzureTelemeter.serialize(e));
        }
        AzureTelemeter.log(type, properties);
    }

    public static void log(AzureTelemetry.Type type, Map<String, String> properties) {
        if (client != null && !StringUtils.equals((CharSequence)properties.get(OP_NAME), (CharSequence)"<unknown>.<unknown>")) {
            properties.putAll(Optional.ofNullable(AzureTelemeter.getCommonProperties()).orElse(new HashMap()));
            String eventName = Optional.ofNullable(AzureTelemeter.getEventNamePrefix()).orElse("AzurePlugin") + "/" + type.name();
            client.trackEvent(eventName, properties, null);
        }
    }

    @Nonnull
    private static Map<String, String> serialize(@Nonnull Operation op) {
        OperationContext context = op.getContext();
        Map<String, String> actionProperties = AzureTelemeter.getActionProperties(op);
        Optional<Operation> parent = Optional.ofNullable(op.getEffectiveParent());
        HashMap<String, String> properties = new HashMap<String, String>();
        String name = op.getId().replaceAll("\\(.+\\)", "(***)");
        String[] parts = name.split("\\.");
        properties.put(OP_ID, op.getExecutionId());
        properties.put(OP_PARENT_ID, parent.map(Operation::getExecutionId).orElse("/"));
        properties.put(OP_NAME, name);
        properties.put(OP_TYPE, op.getType());
        if (parts.length > 1) {
            if (parts[0].contains("/")) {
                String[] typeAndService = parts[0].split("/");
                properties.put(OP_TYPE, typeAndService[0]);
                properties.put(SERVICE_NAME, typeAndService[1]);
            } else {
                properties.put(SERVICE_NAME, parts[0]);
            }
            properties.put(OPERATION_NAME, parts[1]);
        }
        properties.putAll(actionProperties);
        if (op instanceof MethodOperation) {
            properties.putAll(AzureTelemeter.getParameterProperties((MethodOperation)op));
        }
        properties.putAll(context.getTelemetryProperties());
        return properties;
    }

    private static Map<String, String> getParameterProperties(MethodOperation ref) {
        HashMap<String, String> properties = new HashMap<String, String>();
        List<Triple<String, Parameter, Object>> args = ref.getInvocation().getArgs();
        for (Triple<String, Parameter, Object> arg : args) {
            Parameter param = (Parameter)arg.getMiddle();
            Object value = arg.getRight();
            Optional.ofNullable(param.getAnnotation(AzureTelemetry.Property.class)).map(AzureTelemetry.Property::value).map(n -> "<param_name>".equals(n) ? param.getName() : n).ifPresent(name -> properties.put((String)name, Optional.ofNullable(value).map(Object::toString).orElse("")));
            Optional.ofNullable(param.getAnnotation(AzureTelemetry.Properties.class)).map(AzureTelemetry.Properties::value).map(AzureTelemeter::instantiate).map(converter -> converter.convert(value)).ifPresent(properties::putAll);
        }
        return properties;
    }

    @Nonnull
    private static Map<String, String> getActionProperties(@Nonnull Operation operation) {
        return Optional.ofNullable(operation.getActionParent()).map(Operation::getContext).map(OperationContext::getTelemetryProperties).orElse(new HashMap());
    }

    private static <U> U instantiate(Class<? extends U> clazz) {
        return clazz.newInstance();
    }

    @Nonnull
    private static HashMap<String, String> serialize(@Nonnull Throwable e) {
        HashMap<String, String> properties = new HashMap<String, String>();
        ErrorType type = ErrorType.userError;
        properties.put(ERROR_CLASSNAME, e.getClass().getName());
        properties.put(ERROR_TYPE, type.name());
        properties.put(ERROR_MSG, e.getMessage());
        Optional.ofNullable(ExceptionUtils.getRootCause((Throwable)e)).ifPresent(root -> {
            properties.put(ERROR_ROOT_MSG, root.getMessage());
            properties.put(ERROR_ROOT_CLASSNAME, root.getClass().getName());
        });
        properties.put(ERROR_STACKTRACE, ExceptionUtils.getStackTrace((Throwable)e));
        return properties;
    }

    @Nullable
    public static String getEventNamePrefix() {
        return eventNamePrefix;
    }

    public static void setEventNamePrefix(@Nullable String eventNamePrefix) {
        AzureTelemeter.eventNamePrefix = eventNamePrefix;
    }

    @Nullable
    public static AzureTelemetryClient getClient() {
        return client;
    }

    public static void setClient(@Nullable AzureTelemetryClient client) {
        AzureTelemeter.client = client;
    }

    private static enum ErrorType {
        userError,
        systemError,
        serviceError,
        toolError,
        unclassifiedError;

    }
}

