/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.common.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class NetUtils {
    public static final Pattern INTACT_IPADDRESS_PATTERN = Pattern.compile("^\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}$");
    public static final Pattern INTACT_MAC_PATTERN = Pattern.compile("^([0-9A-Fa-f]{2}[:-]){5}[0-9A-Fa-f]{2}$");
    private static final Pattern IPADDRESS_PATTERN = Pattern.compile("\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}");
    private static final Pattern MAC_PATTERN = Pattern.compile("([0-9A-Fa-f]{2}[:-]){5}[0-9A-Fa-f]{2}");
    private static final String[] INVALID_MAC_ADDRESS = new String[]{"00:00:00:00:00:00", "ff:ff:ff:ff:ff:ff", "ac:de:48:00:11:22"};
    private static final String[] UNIX_COMMAND = new String[]{"/sbin/ifconfig -a || /sbin/ip link"};
    private static final String[] WINDOWS_COMMAND = new String[]{"getmac"};
    private static final String[] PUBLIC_IP_URLS = new String[]{"http://whatismyip.akamai.com", "http://bot.whatismyipaddress.com", "https://ipecho.net/plain"};

    public static String getPublicIp() {
        String ip = "";
        for (String urlString : PUBLIC_IP_URLS) {
            ip = NetUtils.getPublicIp(urlString);
            if (!StringUtils.isNotBlank((CharSequence)ip)) continue;
            return ip;
        }
        return ip;
    }

    private static String getPublicIp(String urlString) {
        String ip = "";
        try {
            String trimIp;
            URL url = new URL(urlString);
            HttpURLConnection urlConnection = (HttpURLConnection)url.openConnection();
            BufferedReader in = new BufferedReader(new InputStreamReader(urlConnection.getInputStream(), StandardCharsets.UTF_8));
            while (!((ip = in.readLine()) == null || StringUtils.isNotBlank((CharSequence)ip) && INTACT_IPADDRESS_PATTERN.matcher(trimIp = StringUtils.trim((String)ip)).find())) {
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return ip;
    }

    public static String getHostName() {
        String hostname = "UNKNOWN_HOST";
        try {
            hostname = InetAddress.getLocalHost().getHostName();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return hostname;
    }

    public static String parseIpAddressFromMessage(String message) {
        Matcher matcher;
        if (StringUtils.isNotBlank((CharSequence)message) && (matcher = IPADDRESS_PATTERN.matcher(message)).find()) {
            return matcher.group();
        }
        return "";
    }

    public static String getMac() {
        String commandMac = NetUtils.getMacByCommand();
        if (StringUtils.isNotBlank((CharSequence)commandMac)) {
            return commandMac;
        }
        return NetUtils.getMacByNetworkInterface();
    }

    private static String getMacByCommand() {
        List<String> macs = NetUtils.getMacsByCommand();
        return CollectionUtils.isNotEmpty(macs) ? macs.get(0) : "";
    }

    private static List<String> getMacsByCommand() {
        ArrayList<String> macs = new ArrayList<String>();
        StringBuilder ret = new StringBuilder();
        try {
            String os = System.getProperty("os.name").toLowerCase();
            CharSequence[] command = StringUtils.startsWithIgnoreCase((CharSequence)os, (CharSequence)"win") ? WINDOWS_COMMAND : UNIX_COMMAND;
            ProcessBuilder probuilder = new ProcessBuilder((String[])command);
            Process process = probuilder.start();
            try (InputStream inputStream = process.getInputStream();
                 InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
                 BufferedReader br = new BufferedReader(inputStreamReader);){
                String tmp;
                while ((tmp = br.readLine()) != null) {
                    ret.append(tmp);
                }
            }
            if (process.waitFor() != 0) {
                throw new IOException(String.format("Command %s execute fail.", String.join((CharSequence)" ", command)));
            }
        }
        catch (IOException | InterruptedException ex) {
            return macs;
        }
        String commandMacsString = ret.toString();
        Matcher matcher = MAC_PATTERN.matcher(commandMacsString);
        while (matcher.find()) {
            String mac = matcher.group(0);
            if (!NetUtils.isValidMac(mac)) continue;
            macs.add(mac);
        }
        return macs;
    }

    private static String getMacByNetworkInterface() {
        List<String> macs = NetUtils.getMacsByNetworkInterface();
        if (CollectionUtils.isEmpty(macs)) {
            return "";
        }
        return macs.get(0);
    }

    private static List<String> getMacsByNetworkInterface() {
        ArrayList<String> macs = new ArrayList<String>();
        try {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            while (interfaces.hasMoreElements()) {
                NetworkInterface networkInterface = interfaces.nextElement();
                if (networkInterface.isLoopback() || networkInterface.getHardwareAddress() == null) continue;
                byte[] mac = networkInterface.getHardwareAddress();
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < mac.length; ++i) {
                    sb.append(String.format("%02X%s", mac[i], i < mac.length - 1 ? "-" : ""));
                }
                String macStr = sb.toString();
                if (!NetUtils.isValidMac(macStr)) continue;
                macs.add(macStr);
            }
        }
        catch (SocketException e) {
            return macs;
        }
        return macs;
    }

    private static boolean isValidMac(String mac) {
        if (StringUtils.isEmpty((CharSequence)mac)) {
            return false;
        }
        if (!NetUtils.isValidRawMac(mac)) {
            return false;
        }
        String fixedMac = mac.replaceAll("-", ":");
        return !StringUtils.equalsAnyIgnoreCase((CharSequence)fixedMac, (CharSequence[])INVALID_MAC_ADDRESS);
    }

    private static boolean isValidRawMac(String raw) {
        return StringUtils.isNotEmpty((CharSequence)raw) && INTACT_MAC_PATTERN.matcher(raw).find();
    }
}

