/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.common.operation;

import com.microsoft.azure.toolkit.lib.common.bundle.AzureString;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperation;
import com.microsoft.azure.toolkit.lib.common.operation.OperationBase;
import java.util.concurrent.Callable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SimpleOperation
extends OperationBase {
    @Nonnull
    private final AzureString title;
    @Nonnull
    private final Callable<?> body;
    @Nonnull
    private final AzureOperation.Type type;

    public String toString() {
        return String.format("{name:'%s', method:%s}", this.title.getName(), this.body.getClass().getName());
    }

    @Override
    @Nonnull
    public String getId() {
        return this.title.getName();
    }

    @Override
    @Nonnull
    public String getType() {
        return this.type.name();
    }

    @Override
    @Nullable
    public AzureString getDescription() {
        return this.title;
    }

    public SimpleOperation(@Nonnull AzureString title, @Nonnull Callable<?> body, @Nonnull AzureOperation.Type type) {
        if (title == null) {
            throw new NullPointerException("title is marked non-null but is null");
        }
        if (body == null) {
            throw new NullPointerException("body is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        this.title = title;
        this.body = body;
        this.type = type;
    }

    @Override
    @Nonnull
    public Callable<?> getBody() {
        return this.body;
    }
}

