/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.common.model;

import com.azure.resourcemanager.resources.fluentcore.arm.ResourceId;
import com.microsoft.azure.toolkit.lib.common.exception.AzureToolkitRuntimeException;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResourceModule;
import com.microsoft.azure.toolkit.lib.common.model.AzResource;
import com.microsoft.azure.toolkit.lib.common.model.Refreshable;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jetbrains.annotations.Contract;

public interface AzResourceModule<T extends AzResource>
extends Refreshable {
    @Nonnull
    public static final None NONE = new None();

    @Nonnull
    public List<T> list();

    @Nullable
    default public T get(@Nonnull String resourceId) {
        ResourceId id = ResourceId.fromString((String)resourceId);
        return this.get(id.name(), id.resourceGroupName());
    }

    @Nullable
    public T get(@Nonnull String var1, @Nullable String var2);

    @Nonnull
    public T getOrDraft(@Nonnull String var1, @Nullable String var2);

    public boolean exists(@Nonnull String var1, @Nullable String var2);

    public void delete(@Nonnull String var1, @Nullable String var2);

    @Nonnull
    public T create(@Nonnull AzResource.Draft<T, ?> var1);

    @Nonnull
    public T update(@Nonnull AzResource.Draft<T, ?> var1);

    @Override
    public void refresh();

    @Nonnull
    public String getName();

    @Nonnull
    public String getFullResourceType();

    @Nonnull
    public String getResourceTypeName();

    @Nonnull
    public String getSubscriptionId();

    public static final class None
    extends AbstractAzResourceModule<AzResource.None, AzResource.None, Void> {
        public None() {
            super("$NONE$", AzResource.NONE);
        }

        @Override
        @Nonnull
        protected AzResource.None newResource(@Nonnull Void unused) {
            return AzResource.NONE;
        }

        @Override
        @Nonnull
        protected AzResource.None newResource(@Nonnull String name, @Nullable String resourceGroupName) {
            return AzResource.NONE;
        }

        @Override
        @Nonnull
        public String getResourceTypeName() {
            return "$NONE$";
        }

        @Override
        @Nonnull
        public AzResource.None getParent() {
            return AzResource.NONE;
        }

        @Override
        protected Object getClient() {
            throw new AzureToolkitRuntimeException("not supported");
        }

        @Override
        @Contract(value="null -> false", pure=true)
        public boolean equals(Object o) {
            return o instanceof None;
        }

        @Override
        public int hashCode() {
            return this.getClass().hashCode();
        }
    }
}

