/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.common.model;

import com.azure.core.exception.HttpResponseException;
import com.azure.resourcemanager.resources.fluentcore.arm.ResourceId;
import com.azure.resourcemanager.resources.fluentcore.arm.models.HasId;
import com.azure.resourcemanager.resources.fluentcore.model.Refreshable;
import com.microsoft.azure.toolkit.lib.Azure;
import com.microsoft.azure.toolkit.lib.account.IAzureAccount;
import com.microsoft.azure.toolkit.lib.common.bundle.AzureString;
import com.microsoft.azure.toolkit.lib.common.event.AzureEventBus;
import com.microsoft.azure.toolkit.lib.common.exception.AzureToolkitRuntimeException;
import com.microsoft.azure.toolkit.lib.common.messager.AzureMessager;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResourceModule;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzServiceSubscription;
import com.microsoft.azure.toolkit.lib.common.model.AzResource;
import com.microsoft.azure.toolkit.lib.common.model.AzResourceModule;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperation;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperationAspect;
import com.microsoft.azure.toolkit.lib.common.utils.Debouncer;
import com.microsoft.azure.toolkit.lib.common.utils.TailingDebouncer;
import com.microsoft.azure.toolkit.lib.resource.AzureResources;
import com.microsoft.azure.toolkit.lib.resource.GenericResourceModule;
import com.microsoft.azure.toolkit.lib.resource.ResourceGroup;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAzResource<T extends AbstractAzResource<T, P, R>, P extends AzResource, R>
implements AzResource {
    private static final Logger log;
    @Nonnull
    private final String name;
    @Nonnull
    private final String resourceGroupName;
    @Nonnull
    private final AbstractAzResourceModule<T, P, R> module;
    @Nonnull
    private final AtomicLong syncTimeRef;
    @Nonnull
    private final AtomicReference<R> remoteRef;
    @Nonnull
    private final AtomicReference<String> statusRef;
    @Nonnull
    private final Debouncer fireEvents = new TailingDebouncer(this::fireStatusChangedEvent, 300);
    private final Lock lock = new ReentrantLock();
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    protected AbstractAzResource(@Nonnull String name, @Nonnull String resourceGroupName, @Nonnull AbstractAzResourceModule<T, P, R> module) {
        this.name = name;
        this.resourceGroupName = resourceGroupName;
        this.module = module;
        this.remoteRef = new AtomicReference();
        this.statusRef = new AtomicReference<String>("Unknown");
        this.syncTimeRef = new AtomicLong(-1L);
    }

    protected AbstractAzResource(@Nonnull String name, @Nonnull AbstractAzResourceModule<T, P, R> module) {
        this(name, module.getParent().getResourceGroupName(), module);
    }

    protected AbstractAzResource(@Nonnull AbstractAzResource<T, P, R> origin) {
        this.name = origin.getName();
        this.resourceGroupName = origin.getResourceGroupName();
        this.module = origin.getModule();
        this.remoteRef = origin.remoteRef;
        this.statusRef = origin.statusRef;
        this.syncTimeRef = origin.syncTimeRef;
    }

    @Override
    public boolean exists() {
        P parent = this.getParent();
        if (StringUtils.equals((CharSequence)this.statusRef.get(), (CharSequence)"Deleted")) {
            return false;
        }
        if (parent == AzResource.NONE || this instanceof AbstractAzServiceSubscription || this instanceof ResourceGroup) {
            return this.remoteOptional(new boolean[0]).isPresent();
        }
        ResourceGroup rg = this.getResourceGroup();
        return Objects.nonNull(rg) && rg.exists() && parent.exists() && this.remoteOptional(new boolean[0]).isPresent();
    }

    @Override
    public void refresh() {
        log.debug("[{}:{}]:refresh()", (Object)this.module.getName(), (Object)this.getName());
        this.invalidateCache();
        AzureEventBus.emit("resource.refreshed.resource", this);
    }

    public void invalidateCache() {
        log.debug("[{}]:invalidateCache()", (Object)this.name);
        if (this.lock.tryLock()) {
            try {
                this.syncTimeRef.set(-1L);
            }
            finally {
                this.lock.unlock();
            }
        }
        log.debug("[{}:{}]:invalidateCache->subModules.invalidateCache()", (Object)this.module.getName(), (Object)this.getName());
        this.getSubModules().forEach(AbstractAzResourceModule::invalidateCache);
    }

    @Nullable
    public final R getRemote(boolean ... sync) {
        log.debug("[{}:{}]:getRemote()", (Object)this.module.getName(), (Object)this.getName());
        Azure.az(IAzureAccount.class).account();
        if (this.isDraftForCreating()) {
            log.debug("[{}:{}]:getRemote->this.isDraftForCreating()=true", (Object)this.module.getName(), (Object)this.getName());
            return null;
        }
        if (sync.length > 0 && sync[0]) {
            try {
                this.lock.lock();
                R r = this.getRemoteInner();
                return r;
            }
            finally {
                this.lock.unlock();
            }
        }
        return this.getRemoteInner();
    }

    private R getRemoteInner() {
        if (System.currentTimeMillis() - this.syncTimeRef.get() > 1800000L) {
            R remote = this.remoteRef.get();
            if (this.syncTimeRef.get() == 0L && Objects.nonNull(remote)) {
                return remote;
            }
            try {
                this.lock.lock();
                if (this.syncTimeRef.get() != 0L && System.currentTimeMillis() - this.syncTimeRef.get() > 1800000L) {
                    log.debug("[{}:{}]:getRemote->reloadRemote()", (Object)this.module.getName(), (Object)this.getName());
                    this.reloadRemote();
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return this.remoteRef.get();
    }

    @AzureOperation(name="resource.reload_resource_in_azure.resource|type", params={"this.getName()", "this.getResourceTypeName()"}, type=AzureOperation.Type.REQUEST)
    private void reloadRemote() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            log.debug("[{}:{}]:reloadRemote()", (Object)this.module.getName(), (Object)this.getName());
            this.doModify(() -> {
                Object remote;
                log.debug("[{}:{}]:reloadRemote->this.refreshRemote()", (Object)this.module.getName(), (Object)this.getName());
                R oldRemote = this.remoteRef.get();
                Object refreshed = Objects.nonNull(oldRemote) ? this.refreshRemote(oldRemote) : null;
                log.debug("[{}:{}]:reloadRemote->this.loadRemote()", (Object)this.module.getName(), (Object)this.getName());
                Object v0 = remote = Objects.nonNull(refreshed) ? refreshed : this.loadRemote();
                if (Objects.isNull(remote)) {
                    this.deleteFromCache();
                }
                return remote;
            }, "Loading");
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    protected void setRemote(@Nullable R newRemote) {
        R oldRemote = this.remoteRef.get();
        log.debug("[{}:{}]:setRemote({})", new Object[]{this.module.getName(), this.getName(), newRemote});
        if (oldRemote == null || newRemote == null) {
            log.debug("[{}:{}]:setRemote->subModules.invalidateCache()", (Object)this.module.getName(), (Object)this.getName());
            this.getSubModules().forEach(AbstractAzResourceModule::invalidateCache);
        }
        if (this.lock.tryLock()) {
            try {
                log.debug("[{}:{}]:setRemote->this.remoteRef.set({})", new Object[]{this.module.getName(), this.getName(), newRemote});
                this.remoteRef.set(newRemote);
                this.syncTimeRef.set(System.currentTimeMillis());
                if (Objects.nonNull(newRemote)) {
                    log.debug("[{}:{}]:setRemote->setStatus(LOADING)", (Object)this.module.getName(), (Object)this.getName());
                    this.setStatus("Loading");
                    log.debug("[{}:{}]:setRemote->this.loadStatus", (Object)this.module.getName(), (Object)this.getName());
                    this.updateAdditionalProperties(newRemote, oldRemote);
                    Optional.of(newRemote).map(this::loadStatus).ifPresent(this::setStatus);
                } else {
                    log.debug("[{}:{}]:setRemote->this.setStatus(DISCONNECTED)", (Object)this.module.getName(), (Object)this.getName());
                    this.updateAdditionalProperties(null, oldRemote);
                    this.setStatus("Deleted");
                    this.getSubModules().stream().flatMap(m -> m.listCachedResources().stream()).forEach(r -> r.setRemote(null));
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    protected void updateAdditionalProperties(@Nullable R newRemote, @Nullable R oldRemote) {
    }

    @Nullable
    protected final R loadRemote() {
        log.debug("[{}:{}]:loadRemote()", (Object)this.module.getName(), (Object)this.getName());
        try {
            return ((AbstractAzResourceModule)this.getModule()).loadResourceFromAzure(this.getName(), this.getResourceGroupName());
        }
        catch (Exception e) {
            Throwable cause;
            log.debug("[{}:{}]:loadRemote()=EXCEPTION", new Object[]{this.module.getName(), this.getName(), e});
            Throwable throwable = cause = e instanceof HttpResponseException ? e : ExceptionUtils.getRootCause((Throwable)e);
            if (cause instanceof HttpResponseException && 404 == ((HttpResponseException)cause).getResponse().getStatusCode()) {
                return null;
            }
            throw e;
        }
    }

    @Nullable
    private R refreshRemote(@Nonnull R remote) {
        try {
            return this.refreshRemoteFromAzure(remote);
        }
        catch (Exception e) {
            Throwable cause;
            log.debug("[{}:{}]:refreshRemoteFromAzure()=EXCEPTION", new Object[]{this.module.getName(), this.getName(), e});
            Throwable throwable = cause = e instanceof HttpResponseException ? e : ExceptionUtils.getRootCause((Throwable)e);
            if (cause instanceof HttpResponseException && 404 == ((HttpResponseException)cause).getResponse().getStatusCode()) {
                return null;
            }
            throw e;
        }
    }

    @Nullable
    protected R refreshRemoteFromAzure(@Nonnull R remote) {
        log.debug("[{}:{}]:refreshRemoteFromAzure()", (Object)this.module.getName(), (Object)this.getName());
        if (remote instanceof Refreshable) {
            log.debug("[{}:{}]:refreshRemoteFromAzure->remote.refresh()", (Object)this.module.getName(), (Object)this.getName());
            return (R)((Refreshable)remote).refresh();
        }
        log.debug("[{}:{}]:refreshRemoteFromAzure->reloadRemote()", (Object)this.module.getName(), (Object)this.getName());
        return this.loadRemote();
    }

    @Nonnull
    public AzResource.Draft<T, R> update() {
        log.debug("[{}:{}]:update()", (Object)this.module.getName(), (Object)this.getName());
        log.debug("[{}:{}]:update->module.update(this)", (Object)this.module.getName(), (Object)this.getName());
        return ((AbstractAzResourceModule)this.getModule()).update((AbstractAzResource)this.cast(this));
    }

    @Override
    public void delete() {
        log.debug("[{}:{}]:delete()", (Object)this.module.getName(), (Object)this.getName());
        this.doModify(() -> {
            if (this.exists()) {
                this.deleteFromAzure();
            }
            return null;
        }, "Deleting");
        this.deleteFromCache();
    }

    private void deleteFromAzure() {
        log.debug("[{}:{}]:delete->module.deleteResourceFromAzure({})", new Object[]{this.module.getName(), this.getName(), this.getId()});
        try {
            ((AbstractAzResourceModule)this.getModule()).deleteResourceFromAzure(this.getId());
        }
        catch (Exception e) {
            Throwable cause;
            Throwable throwable = cause = e instanceof HttpResponseException ? e : ExceptionUtils.getRootCause((Throwable)e);
            if (cause instanceof HttpResponseException && 404 == ((HttpResponseException)cause).getResponse().getStatusCode()) {
                log.debug("[{}]:delete()->deleteResourceFromAzure()=SC_NOT_FOUND", (Object)this.name, (Object)e);
            }
            this.getSubModules().stream().flatMap(m -> m.listCachedResources().stream()).forEach(r -> r.setStatus("Unknown"));
            throw e;
        }
    }

    public void deleteFromCache() {
        log.debug("[{}:{}]:delete->this.setStatus(DELETED)", (Object)this.module.getName(), (Object)this.getName());
        this.setStatus("Deleted");
        log.debug("[{}:{}]:delete->module.deleteResourceFromLocal({})", new Object[]{this.module.getName(), this.getName(), this.getName()});
        ((AbstractAzResourceModule)this.getModule()).deleteResourceFromLocal(this.getId(), new boolean[0]);
        ResourceId id = ResourceId.fromString((String)this.getId());
        ResourceGroup resourceGroup = this.getResourceGroup();
        if (Objects.isNull(id.parent()) && Objects.nonNull(resourceGroup)) {
            GenericResourceModule genericResourceModule = resourceGroup.genericResources();
            genericResourceModule.deleteResourceFromLocal(this.getId(), new boolean[0]);
        }
        this.getSubModules().stream().flatMap(m -> m.listCachedResources().stream()).forEach(AbstractAzResource::deleteFromCache);
    }

    public void reloadStatus() {
        this.setStatus(this.loadStatus(this.getRemote(new boolean[0])));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStatus(@Nonnull String status) {
        AtomicReference<String> atomicReference = this.statusRef;
        synchronized (atomicReference) {
            log.debug("[{}:{}]:setStatus({})", new Object[]{this.module.getName(), this.getName(), status});
            String oldStatus = this.statusRef.get();
            if (!Objects.equals(oldStatus, status)) {
                this.statusRef.set(status);
                this.fireEvents.debounce();
                if (StringUtils.equalsAny((CharSequence)status, (CharSequence[])new CharSequence[]{"Deleting", "Deleted"})) {
                    this.getSubModules().stream().flatMap(m -> m.listCachedResources().stream()).forEach(r -> r.setStatus(status));
                }
            }
        }
    }

    @Override
    @Nonnull
    public String getStatus() {
        if (this.syncTimeRef.get() == -1L) {
            log.debug("[{}:{}]:getStatus->getStatusSync()", (Object)this.module.getName(), (Object)this.getName());
            this.getRemote(new boolean[0]);
        }
        return this.statusRef.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doModify(@Nonnull Runnable body, @Nullable String status) {
        if (this.lock.tryLock()) {
            try {
                this.syncTimeRef.set(0L);
                this.setStatus(Optional.ofNullable(status).orElse("Pending"));
                log.debug("[{}:{}]:doModify->body.run()", (Object)this.module.getName(), (Object)this.getName());
                body.run();
                log.debug("[{}:{}]:doModify->refreshRemote()", (Object)this.module.getName(), (Object)this.getName());
                R refreshed = Optional.ofNullable(this.remoteRef.get()).map(this::refreshRemote).orElse(null);
                log.debug("[{}:{}]:doModify->setRemote({})", new Object[]{this.module.getName(), this.getName(), this.remoteRef.get()});
                this.setRemote(refreshed);
            }
            catch (Throwable t) {
                Throwable cause;
                Throwable throwable = cause = t instanceof HttpResponseException ? t : ExceptionUtils.getRootCause((Throwable)t);
                if (cause instanceof HttpResponseException && 404 == ((HttpResponseException)cause).getResponse().getStatusCode()) {
                    this.setRemote(null);
                }
                this.syncTimeRef.compareAndSet(0L, System.currentTimeMillis());
                this.setStatus("Unknown");
                throw t;
            }
            finally {
                this.lock.unlock();
            }
        } else {
            AzureMessager.getMessager().warning(AzureString.format("%s (%s) is %s, please wait until it's finished.", this.getResourceTypeName(), this.getName(), this.getStatus()));
        }
    }

    @Nullable
    public R doModify(@Nonnull Callable<R> body, @Nullable String status) {
        if (!this.lock.tryLock()) {
            AzureMessager.getMessager().warning(AzureString.format("%s (%s) is %s, waiting until it's finished.", this.getResourceTypeName(), this.getName(), this.getStatus()));
            this.lock.lock();
        }
        try {
            this.syncTimeRef.set(0L);
            this.setStatus(Optional.ofNullable(status).orElse("Pending"));
            log.debug("[{}:{}]:doModify->body.call()", (Object)this.module.getName(), (Object)this.getName());
            R remote = body.call();
            log.debug("[{}:{}]:doModify->setRemote({})", new Object[]{this.module.getName(), this.getName(), remote});
            this.setRemote(remote);
            R r = remote;
            return r;
        }
        catch (Throwable t) {
            Throwable cause;
            Throwable throwable = cause = t instanceof HttpResponseException ? t : ExceptionUtils.getRootCause((Throwable)t);
            if (cause instanceof HttpResponseException && 404 == ((HttpResponseException)cause).getResponse().getStatusCode()) {
                this.setRemote(null);
                R r = null;
                return r;
            }
            this.syncTimeRef.compareAndSet(0L, System.currentTimeMillis());
            this.setStatus("Unknown");
            throw t instanceof AzureToolkitRuntimeException ? (AzureToolkitRuntimeException)t : new AzureToolkitRuntimeException(t);
        }
        finally {
            this.lock.unlock();
        }
    }

    private void fireStatusChangedEvent() {
        log.debug("[{}]:fireStatusChangedEvent()", (Object)this.getName());
        AzureEventBus.emit("resource.status_changed.resource", this);
    }

    @Override
    @Nonnull
    public String getId() {
        R r = this.remoteRef.get();
        if (r instanceof HasId) {
            return ((HasId)r).id();
        }
        return ((AbstractAzResourceModule)this.getModule()).toResourceId(this.getName(), this.getResourceGroupName());
    }

    @Nonnull
    public abstract List<AbstractAzResourceModule<?, ?, ?>> getSubModules();

    @Nonnull
    public abstract String loadStatus(@Nonnull R var1);

    @Nonnull
    protected Optional<R> remoteOptional(boolean ... sync) {
        return Optional.ofNullable(this.getRemote(sync));
    }

    @Nonnull
    private <D> D cast(@Nonnull Object origin) {
        return (D)origin;
    }

    @Nullable
    public AbstractAzResourceModule<?, ?, ?> getSubModule(String moduleName) {
        return this.getSubModules().stream().filter(m -> m.getName().equalsIgnoreCase(moduleName)).findAny().orElse(null);
    }

    @Nullable
    public ResourceGroup getResourceGroup() {
        boolean isResourceGroupSet;
        String rgName = this.getResourceGroupName();
        String sid = this.getSubscriptionId();
        boolean isSubscriptionSet = StringUtils.isNotBlank((CharSequence)sid) && !StringUtils.equalsAnyIgnoreCase((CharSequence)sid, (CharSequence[])new CharSequence[]{"<none>", NONE.getName()});
        boolean bl = isResourceGroupSet = StringUtils.isNotBlank((CharSequence)rgName) && !StringUtils.equalsAnyIgnoreCase((CharSequence)rgName, (CharSequence[])new CharSequence[]{"<none>", NONE.getName(), "${rg}"});
        if (!isResourceGroupSet || !isSubscriptionSet) {
            return null;
        }
        return (ResourceGroup)Azure.az(AzureResources.class).groups(this.getSubscriptionId()).get(rgName, rgName);
    }

    @Nonnull
    public P getParent() {
        return ((AbstractAzResourceModule)this.getModule()).getParent();
    }

    public boolean isDraft() {
        return this.isDraftForCreating() || this.isDraftForUpdating();
    }

    public boolean isDraftForCreating() {
        return this instanceof AzResource.Draft && Objects.isNull(((AzResource.Draft)((Object)this)).getOrigin()) && Objects.isNull(this.remoteRef.get());
    }

    public boolean isDraftForUpdating() {
        return this instanceof AzResource.Draft && Objects.nonNull(((AzResource.Draft)((Object)this)).getOrigin());
    }

    public String toString() {
        return "AbstractAzResource(name=" + this.getName() + ", resourceGroupName=" + this.getResourceGroupName() + ", syncTimeRef=" + this.syncTimeRef + ", statusRef=" + this.statusRef + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractAzResource)) {
            return false;
        }
        AbstractAzResource other = (AbstractAzResource)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$resourceGroupName = this.getResourceGroupName();
        String other$resourceGroupName = other.getResourceGroupName();
        if (this$resourceGroupName == null ? other$resourceGroupName != null : !this$resourceGroupName.equals(other$resourceGroupName)) {
            return false;
        }
        AzResourceModule this$module = this.getModule();
        AzResourceModule other$module = other.getModule();
        return !(this$module == null ? other$module != null : !this$module.equals(other$module));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AbstractAzResource;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $resourceGroupName = this.getResourceGroupName();
        result = result * 59 + ($resourceGroupName == null ? 43 : $resourceGroupName.hashCode());
        AzResourceModule $module = this.getModule();
        result = result * 59 + ($module == null ? 43 : $module.hashCode());
        return result;
    }

    @Override
    @Nonnull
    public String getName() {
        return this.name;
    }

    @Override
    @Nonnull
    public String getResourceGroupName() {
        return this.resourceGroupName;
    }

    @Nonnull
    public AbstractAzResourceModule<T, P, R> getModule() {
        return this.module;
    }

    static {
        AbstractAzResource.ajc$preClinit();
        log = LoggerFactory.getLogger(AbstractAzResource.class);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("AbstractAzResource.java", AbstractAzResource.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "reloadRemote", "com.microsoft.azure.toolkit.lib.common.model.AbstractAzResource", "", "", "", "void"), 177);
    }
}

