/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.resource;

import com.azure.resourcemanager.resources.fluentcore.arm.ResourceId;
import com.azure.resourcemanager.resources.fluentcore.arm.models.HasId;
import com.microsoft.azure.toolkit.lib.Azure;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResource;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResourceModule;
import com.microsoft.azure.toolkit.lib.resource.GenericResourceModule;
import com.microsoft.azure.toolkit.lib.resource.ResourceGroup;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class GenericResource
extends AbstractAzResource<GenericResource, ResourceGroup, HasId> {
    @Nonnull
    private final ResourceId resourceId;
    @Nullable
    private AbstractAzResource<?, ?, ?> concrete;

    protected GenericResource(@Nonnull String resourceId, @Nonnull GenericResourceModule module) {
        super(resourceId, ResourceId.fromString((String)resourceId).resourceGroupName(), module);
        this.resourceId = ResourceId.fromString((String)resourceId);
    }

    protected GenericResource(@Nonnull GenericResource origin) {
        super(origin);
        this.resourceId = origin.resourceId;
    }

    protected GenericResource(@Nonnull HasId remote, @Nonnull GenericResourceModule module) {
        super(remote.id(), ((ResourceGroup)module.getParent()).getResourceGroupName(), module);
        this.resourceId = ResourceId.fromString((String)remote.id());
    }

    protected GenericResource(@Nonnull AbstractAzResource<?, ?, ?> concrete, @Nonnull GenericResourceModule module) {
        this(concrete::getId, module);
        this.concrete = concrete;
    }

    public synchronized AbstractAzResource<?, ?, ?> toConcreteResource() {
        if (Objects.isNull(this.concrete)) {
            this.concrete = Azure.az().getOrInitById(this.resourceId.id());
        }
        return Objects.isNull(this.concrete) ? this : this.concrete;
    }

    @Override
    @Nullable
    protected HasId refreshRemoteFromAzure(@Nonnull HasId remote) {
        return remote;
    }

    @Override
    @Nonnull
    public List<AbstractAzResourceModule<?, GenericResource, ?>> getSubModules() {
        return Collections.emptyList();
    }

    @Override
    @Nonnull
    public String loadStatus(@Nonnull HasId remote) {
        return "Unknown";
    }

    public String getKind() {
        return this.remoteOptional(new boolean[0]).filter(r -> r instanceof com.azure.resourcemanager.resources.models.GenericResource).map(r -> ((com.azure.resourcemanager.resources.models.GenericResource)r).kind()).orElseGet(() -> Objects.nonNull(this.concrete) ? this.concrete.getClass().getSimpleName() : "");
    }

    @Override
    @Nonnull
    public String getFullResourceType() {
        return this.resourceId.fullResourceType();
    }

    @Override
    @Nonnull
    public String getResourceTypeName() {
        return this.getFullResourceType();
    }

    @Nonnull
    public ResourceId getResourceId() {
        return this.resourceId;
    }
}

