/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.common.messager;

import com.azure.core.exception.HttpResponseException;
import com.azure.core.http.HttpResponse;
import com.azure.core.management.exception.ManagementError;
import com.azure.core.management.exception.ManagementException;
import com.google.common.collect.Lists;
import com.google.common.collect.Streams;
import com.microsoft.azure.toolkit.lib.common.action.Action;
import com.microsoft.azure.toolkit.lib.common.action.AzureActionManager;
import com.microsoft.azure.toolkit.lib.common.bundle.AzureString;
import com.microsoft.azure.toolkit.lib.common.exception.AzureToolkitException;
import com.microsoft.azure.toolkit.lib.common.exception.AzureToolkitRuntimeException;
import com.microsoft.azure.toolkit.lib.common.messager.IAzureMessage;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperation;
import com.microsoft.azure.toolkit.lib.common.operation.Operation;
import com.microsoft.azure.toolkit.lib.common.operation.OperationException;
import com.microsoft.azure.toolkit.lib.common.operation.OperationThreadContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import reactor.core.publisher.Mono;

public class AzureMessage
implements IAzureMessage {
    @Nonnull
    protected final IAzureMessage.Type type;
    @Nonnull
    protected final AzureString message;
    @Nullable
    protected String title;
    @Nullable
    protected Object payload;
    @Nullable
    protected Object[] actions;
    protected IAzureMessage.ValueDecorator valueDecorator;

    @Override
    @Nonnull
    public String getContent() {
        if (!(this.getPayload() instanceof Throwable)) {
            return (String)ObjectUtils.firstNonNull((Object[])new String[]{this.decorateText(this.message, null), this.message.getString()});
        }
        Throwable throwable = (Throwable)this.getPayload();
        List<Operation> operations = this.getOperations();
        String failure = operations.stream().findFirst().map(Operation::getDescription).map(azureString -> "Failed to " + this.decorateText((AzureString)azureString, azureString::getString)).orElse("Failed to proceed");
        String cause = Optional.ofNullable(this.getCause(throwable)).map(c -> ", " + c).orElse("");
        String tips = Optional.ofNullable(this.getExceptionTips(throwable)).map(c -> System.lineSeparator() + c).orElse("");
        return failure + cause + tips;
    }

    public String getDetails() {
        List<Operation> operations = this.getOperations();
        return this.getPayload() instanceof Throwable && operations.size() < 2 ? "" : operations.stream().map(this::getDetailItem).filter(xva$0 -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{xva$0})).collect(Collectors.joining("", "", ""));
    }

    protected String getDetailItem(Operation o) {
        return Optional.ofNullable(o.getDescription()).map(t -> this.decorateText((AzureString)t, t::getString)).map(StringUtils::capitalize).map(t -> String.format("\u25cf %s", t)).orElse(null);
    }

    @Override
    @Nullable
    public String decorateValue(@Nonnull Object p, @Nullable Supplier<String> dft) {
        String result = IAzureMessage.super.decorateValue(p, null);
        if (Objects.isNull(result) && Objects.nonNull(this.valueDecorator)) {
            result = this.valueDecorator.decorateValue(p, this);
        }
        return Objects.isNull(result) && Objects.nonNull(dft) ? dft.get() : result;
    }

    @Nullable
    protected String getCause(@Nonnull Throwable throwable) {
        Throwable root = AzureMessage.getRecognizableCause(throwable);
        if (Objects.isNull(root)) {
            return ExceptionUtils.getRootCause((Throwable)throwable).toString();
        }
        String cause = null;
        if (root instanceof ManagementException) {
            cause = Optional.of((ManagementException)root).map(ManagementException::getValue).map(ManagementError::getMessage).orElse("Unknown cause");
        } else if (root instanceof HttpResponseException) {
            cause = Optional.of((HttpResponseException)root).map(HttpResponseException::getResponse).map(HttpResponse::getBodyAsString).map(Mono::block).orElse("Unknown cause");
        }
        String causeMsg = (String)StringUtils.firstNonBlank((CharSequence[])new String[]{cause, root.getMessage()});
        return Optional.ofNullable(causeMsg).filter(StringUtils::isNotBlank).map(StringUtils::uncapitalize).map(c -> c.endsWith(".") ? c : c + '.').orElse(null);
    }

    @Nullable
    private static Throwable getRecognizableCause(@Nonnull Throwable throwable) {
        List throwables = ExceptionUtils.getThrowableList((Throwable)throwable);
        for (int i = throwables.size() - 1; i >= 0; --i) {
            String rootClassName;
            Throwable t = (Throwable)throwables.get(i);
            if (t instanceof OperationException || !(rootClassName = t.getClass().getName()).startsWith("com.microsoft") && !rootClassName.startsWith("com.azure")) continue;
            return t;
        }
        return null;
    }

    @Nullable
    protected String getExceptionTips(@Nonnull Throwable throwable) {
        return ExceptionUtils.getThrowableList((Throwable)throwable).stream().filter(t -> t instanceof AzureToolkitRuntimeException || t instanceof AzureToolkitException).map(t -> t instanceof AzureToolkitRuntimeException ? ((AzureToolkitRuntimeException)t).getTips() : ((AzureToolkitException)t).getTips()).filter(StringUtils::isNotBlank).findFirst().map(StringUtils::capitalize).orElse(null);
    }

    @Nonnull
    protected List<Operation> getOperations() {
        List exceptionOperations = Optional.ofNullable(this.getPayload()).filter(p -> p instanceof Throwable).map(p -> AzureMessage.getExceptionOperations((Throwable)p)).orElse(new ArrayList());
        Operation current = exceptionOperations.isEmpty() ? OperationThreadContext.current().currentOperation() : (Operation)exceptionOperations.get(0);
        List<Operation> contextOperations = AzureMessage.getAncestorOperationsUtilAction(current);
        ConcurrentHashMap.KeySetView seen = ConcurrentHashMap.newKeySet();
        List operations = Streams.concat((Stream[])new Stream[]{contextOperations.stream(), exceptionOperations.stream()}).filter(t -> seen.add(t.getId())).filter(o -> Objects.nonNull(o.getDescription())).collect(Collectors.toList());
        return Lists.reverse(operations);
    }

    @Nonnull
    private static List<Operation> getAncestorOperationsUtilAction(Operation current) {
        LinkedList<Operation> result = new LinkedList<Operation>();
        while (Objects.nonNull(current)) {
            result.addFirst(current);
            if (AzureOperation.Type.ACTION.name().equals(current.getType())) break;
            current = current.getParent();
        }
        return result;
    }

    @Nonnull
    private static List<Operation> getExceptionOperations(@Nonnull Throwable throwable) {
        return ExceptionUtils.getThrowableList((Throwable)throwable).stream().filter(object -> object instanceof OperationException).map(o -> ((OperationException)o).getOperation()).collect(Collectors.toList());
    }

    @Nonnull
    private static List<Object> getExceptionActions(@Nonnull Throwable throwable) {
        return ExceptionUtils.getThrowableList((Throwable)throwable).stream().filter(object -> object instanceof AzureToolkitRuntimeException || object instanceof AzureToolkitException).flatMap(o -> {
            Object[] actions = o instanceof AzureToolkitRuntimeException ? ((AzureToolkitRuntimeException)o).getActions() : ((AzureToolkitException)o).getActions();
            return Arrays.stream((Object[])ObjectUtils.firstNonNull((Object[])new Object[][]{actions, new Object[0]}));
        }).collect(Collectors.toList());
    }

    @Override
    @Nonnull
    public String getTitle() {
        return (String)ObjectUtils.firstNonNull((Object[])new String[]{this.title, ""});
    }

    @Override
    @Nonnull
    public Action<?>[] getActions() {
        Object payload = this.getPayload();
        ArrayList<Object> actions = new ArrayList<Object>(Arrays.asList((Object[])ObjectUtils.firstNonNull((Object[])new Object[][]{this.actions, new Object[0]})));
        if (payload instanceof Throwable) {
            actions.addAll(AzureMessage.getExceptionActions((Throwable)payload));
        }
        return (Action[])actions.stream().filter(ObjectUtils::isNotEmpty).map(this::toAction).filter(Objects::nonNull).distinct().toArray(Action[]::new);
    }

    public AzureMessage setActions(Object[] actions) {
        this.actions = actions;
        return this;
    }

    private Action<?> toAction(Object action) {
        AzureActionManager am = AzureActionManager.getInstance();
        try {
            if (action instanceof String) {
                Action.Id id = Action.Id.of((String)action);
                return am.getAction(id);
            }
            if (action instanceof Action.Id) {
                return am.getAction((Action.Id)action);
            }
            return (Action)action;
        }
        catch (Throwable t) {
            return null;
        }
    }

    public AzureMessage(@Nonnull IAzureMessage.Type type, @Nonnull AzureString message) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        this.type = type;
        this.message = message;
    }

    @Override
    @Nonnull
    public IAzureMessage.Type getType() {
        return this.type;
    }

    @Override
    @Nonnull
    public AzureString getMessage() {
        return this.message;
    }

    @Override
    @Nullable
    public Object getPayload() {
        return this.payload;
    }

    public IAzureMessage.ValueDecorator getValueDecorator() {
        return this.valueDecorator;
    }

    public AzureMessage setTitle(@Nullable String title) {
        this.title = title;
        return this;
    }

    public AzureMessage setPayload(@Nullable Object payload) {
        this.payload = payload;
        return this;
    }

    public AzureMessage setValueDecorator(IAzureMessage.ValueDecorator valueDecorator) {
        this.valueDecorator = valueDecorator;
        return this;
    }
}

