/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.tools.common.util;

import com.microsoft.azure.tools.common.exception.CommandExecuteException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;

public class CommandUtil {
    private static final boolean isWindows = System.getProperty("os.name").contains("Windows");

    public static String executeCommandAndGetOutput(String cmd, File cwd) throws IOException, InterruptedException {
        String[] cmds = new String[]{isWindows ? "cmd.exe" : "bash", isWindows ? "/c" : "-c", cmd};
        Process p = Runtime.getRuntime().exec(cmds, null, cwd);
        int exitCode = p.waitFor();
        if (exitCode != 0) {
            String errorLog = IOUtils.toString((InputStream)p.getErrorStream(), (Charset)StandardCharsets.UTF_8);
            throw new CommandExecuteException(String.format("Cannot execute '%s' due to error: %s", cmd, errorLog));
        }
        return IOUtils.toString((InputStream)p.getInputStream(), (Charset)StandardCharsets.UTF_8);
    }
}

