/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.common.telemetry;

import com.microsoft.applicationinsights.TelemetryClient;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class AzureTelemetryClient {
    private static final String[] SYSTEM_PROPERTIES = new String[]{"resourceType"};
    private static final String FILE_PATH_REGEX = "(file://)?([a-zA-Z]:(\\\\\\\\|\\\\|/)|(\\\\\\\\|\\\\|/))?([\\w-._]+(\\\\\\\\|\\\\|/))+[\\w-._]*";
    private static final Pattern FILE_PATH_PATTERN = Pattern.compile("(file://)?([a-zA-Z]:(\\\\\\\\|\\\\|/)|(\\\\\\\\|\\\\|/))?([\\w-._]+(\\\\\\\\|\\\\|/))+[\\w-._]*");
    private static final String EMAIL_REGEX = "(?:[a-z0-9!#$%&'*+/=?^_`{|}~-]+(?:\\.[a-z0-9!#$%&'*+/=?^_`{|}~-]+)*|\"(?:[\\x01-\\x08\\x0b\\x0c\\x0e-\\x1f\\x21\\x23-\\x5b\\x5d-\\x7f]|\\\\[\\x01-\\x09\\x0b\\x0c\\x0e-\\x7f])*\")@(?:(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?|\\[(?:(?:(2(5[0-5]|[0-4][0-9])|1[0-9][0-9]|[1-9]?[0-9]))\\.){3}(?:(2(5[0-5]|[0-4][0-9])|1[0-9][0-9]|[1-9]?[0-9])|[a-z0-9-]*[a-z0-9]:(?:[\\x01-\\x08\\x0b\\x0c\\x0e-\\x1f\\x21-\\x5a\\x53-\\x7f]|\\\\[\\x01-\\x09\\x0b\\x0c\\x0e-\\x7f])+)])";
    private static final Pattern EMAIL_PATTERN = Pattern.compile("(?:[a-z0-9!#$%&'*+/=?^_`{|}~-]+(?:\\.[a-z0-9!#$%&'*+/=?^_`{|}~-]+)*|\"(?:[\\x01-\\x08\\x0b\\x0c\\x0e-\\x1f\\x21\\x23-\\x5b\\x5d-\\x7f]|\\\\[\\x01-\\x09\\x0b\\x0c\\x0e-\\x7f])*\")@(?:(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?|\\[(?:(?:(2(5[0-5]|[0-4][0-9])|1[0-9][0-9]|[1-9]?[0-9]))\\.){3}(?:(2(5[0-5]|[0-4][0-9])|1[0-9][0-9]|[1-9]?[0-9])|[a-z0-9-]*[a-z0-9]:(?:[\\x01-\\x08\\x0b\\x0c\\x0e-\\x1f\\x21-\\x5a\\x53-\\x7f]|\\\\[\\x01-\\x09\\x0b\\x0c\\x0e-\\x7f])+)])");
    private final TelemetryClient client = new TelemetryClient();
    private Map<String, String> defaultProperties;
    private boolean isEnabled = true;

    public AzureTelemetryClient() {
        this(Collections.emptyMap());
    }

    public AzureTelemetryClient(@Nonnull Map<String, String> defaultProperties) {
        this.defaultProperties = new HashMap<String, String>(defaultProperties);
    }

    public void addDefaultProperty(@Nonnull String key, @Nonnull String value) {
        if (StringUtils.isEmpty((CharSequence)key)) {
            return;
        }
        this.defaultProperties.put(key, value);
    }

    public void enable() {
        this.isEnabled = true;
    }

    public void disable() {
        this.isEnabled = false;
    }

    public void trackEvent(@Nonnull String eventName) {
        this.trackEvent(eventName, null, null, false);
    }

    public void trackEvent(@Nonnull String eventName, @Nullable Map<String, String> customProperties) {
        this.trackEvent(eventName, customProperties, null, false);
    }

    public void trackEvent(@Nonnull String eventName, @Nullable Map<String, String> customProperties, @Nullable Map<String, Double> metrics) {
        this.trackEvent(eventName, customProperties, metrics, false);
    }

    public void trackEvent(@Nonnull String eventName, @Nullable Map<String, String> customProperties, @Nullable Map<String, Double> metrics, boolean overrideDefaultProperties) {
        if (!this.isEnabled()) {
            return;
        }
        Map<String, String> properties = this.mergeProperties(this.getDefaultProperties(), customProperties, overrideDefaultProperties);
        properties.entrySet().removeIf(stringStringEntry -> StringUtils.isEmpty((CharSequence)((CharSequence)stringStringEntry.getValue())));
        this.anonymizePersonallyIdentifiableInformation(properties);
        this.client.trackEvent(eventName, properties, metrics);
        this.client.flush();
    }

    protected Map<String, String> mergeProperties(Map<String, String> defaultProperties, Map<String, String> customProperties, boolean overrideDefaultProperties) {
        if (customProperties == null) {
            return defaultProperties;
        }
        HashMap<String, String> merged = new HashMap<String, String>();
        if (overrideDefaultProperties) {
            merged.putAll(defaultProperties);
            merged.putAll(customProperties);
        } else {
            merged.putAll(customProperties);
            merged.putAll(defaultProperties);
        }
        return merged;
    }

    private void anonymizePersonallyIdentifiableInformation(Map<String, String> properties) {
        properties.replaceAll((key, value) -> {
            if (StringUtils.isBlank((CharSequence)value) || StringUtils.equalsAnyIgnoreCase((CharSequence)key, (CharSequence[])SYSTEM_PROPERTIES)) {
                return value;
            }
            String input = FILE_PATH_PATTERN.matcher((CharSequence)value).replaceAll("<REDACTED: user-file-path>");
            return EMAIL_PATTERN.matcher(input).replaceAll("<REDACTED: user-email-address>");
        });
    }

    public TelemetryClient getClient() {
        return this.client;
    }

    public Map<String, String> getDefaultProperties() {
        return this.defaultProperties;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public void setDefaultProperties(Map<String, String> defaultProperties) {
        this.defaultProperties = defaultProperties;
    }
}

