/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.common.telemetry;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.microsoft.azure.toolkit.lib.common.DataStore;
import com.microsoft.azure.toolkit.lib.common.operation.IAzureOperation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class AzureTelemetry {
    static final DataStore.Field<Context> TELEMETRY_CONTEXT = DataStore.Field.of("telemeryContext");
    static final String OP_CREATE_AT = "op_create_at";
    static final String OP_ENTER_AT = "op_enter_at";
    static final String OP_EXIT_AT = "op_exit_at";

    @Nonnull
    public static Context getActionContext() {
        return AzureTelemetry.getContext().getActionParent();
    }

    @Nonnull
    public static Context getContext() {
        return Optional.ofNullable(IAzureOperation.current()).map(o -> o.get(TELEMETRY_CONTEXT, new Context((IAzureOperation<?>)o))).orElse(new Context(null));
    }

    @Nonnull
    public static Context getContext(IAzureOperation<?> op) {
        return Optional.ofNullable(op).map(o -> o.get(TELEMETRY_CONTEXT, new Context((IAzureOperation<?>)o))).orElse(new Context(null));
    }

    public static class Context {
        private final Map<String, String> properties = new ConcurrentHashMap<String, String>();
        @Nullable
        private final IAzureOperation<?> operation;

        public void setCreateAt(Instant createAt) {
            this.properties.put(AzureTelemetry.OP_CREATE_AT, createAt.toString());
        }

        public void setEnterAt(Instant enterAt) {
            this.properties.put(AzureTelemetry.OP_ENTER_AT, enterAt.toString());
        }

        public void setExitAt(Instant exitAt) {
            this.properties.put(AzureTelemetry.OP_EXIT_AT, exitAt.toString());
        }

        public void setProperty(String key, String val) {
            this.properties.put(key, val);
        }

        public void setProperties(Map<String, String> properties) {
            this.properties.putAll(properties);
        }

        public String getProperty(String key) {
            return this.properties.get(key);
        }

        public Context getActionParent() {
            return Optional.ofNullable(this.operation).map(IAzureOperation::getActionParent).map(o -> o.get(TELEMETRY_CONTEXT, new Context((IAzureOperation<?>)o))).orElse(new Context(this.operation));
        }

        public Map<String, String> getProperties() {
            return this.properties;
        }

        @Nullable
        public IAzureOperation<?> getOperation() {
            return this.operation;
        }

        public Context(@Nullable IAzureOperation<?> operation) {
            this.operation = operation;
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER})
    public static @interface Properties {
        public Class<? extends Converter> value() default DefaultConverter.class;

        public static class DefaultConverter
        implements Converter<Object> {
            private static final ObjectMapper objectMapper = new ObjectMapper();
            private static final TypeReference<Map<String, String>> type = new TypeReference<Map<String, String>>(){};

            @Override
            @Nonnull
            public Map<String, String> convert(@Nullable Object obj) {
                return Optional.ofNullable(obj).map(o -> (Map)objectMapper.convertValue(o, type)).orElse(new HashMap());
            }
        }

        public static interface Converter<T> {
            @Nonnull
            public Map<String, String> convert(@Nullable T var1);
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER})
    public static @interface Property {
        public static final String PARAM_NAME = "<param_name>";

        public String value() default "<param_name>";
    }

    public static enum Type {
        OP_START,
        OP_END,
        STEP,
        INFO,
        WARNING,
        ERROR;

    }
}

