/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.auth.serviceprincipal;

import com.azure.core.credential.TokenCredential;
import com.azure.identity.ClientCertificateCredentialBuilder;
import com.azure.identity.ClientSecretCredentialBuilder;
import com.microsoft.azure.toolkit.lib.auth.Account;
import com.microsoft.azure.toolkit.lib.auth.AuthConfiguration;
import com.microsoft.azure.toolkit.lib.auth.AuthType;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;

public class ServicePrincipalAccount
extends Account {
    private final AuthType type = AuthType.SERVICE_PRINCIPAL;

    public ServicePrincipalAccount(@Nonnull AuthConfiguration config) {
        super(config);
    }

    @Override
    public boolean checkAvailable() {
        AuthConfiguration config = this.getConfig();
        return !StringUtils.isAllBlank((CharSequence[])new CharSequence[]{config.getCertificate(), config.getCertificatePassword(), config.getKey()});
    }

    @Override
    @Nonnull
    protected TokenCredential buildDefaultTokenCredential() {
        AuthConfiguration config = this.getConfig();
        return StringUtils.isNotBlank((CharSequence)config.getCertificate()) ? ((ClientCertificateCredentialBuilder)((ClientCertificateCredentialBuilder)((ClientCertificateCredentialBuilder)((ClientCertificateCredentialBuilder)new ClientCertificateCredentialBuilder().tenantId(config.getTenant())).clientId(config.getClient())).pfxCertificate(config.getCertificate(), config.getCertificatePassword()).additionallyAllowedTenants(new String[]{"*"})).tokenCachePersistenceOptions(this.getPersistenceOptions()).executorService(config.getExecutorService())).build() : ((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)new ClientSecretCredentialBuilder().tenantId(config.getTenant())).clientId(config.getClient())).clientSecret(config.getKey()).additionallyAllowedTenants(new String[]{"*"})).tokenCachePersistenceOptions(this.getPersistenceOptions()).executorService(config.getExecutorService())).build();
    }

    @Override
    public String getClientId() {
        return this.getConfig().getClient();
    }

    @Override
    public AuthType getType() {
        return this.type;
    }
}

