/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.auth.managedidentity;

import com.azure.core.credential.TokenCredential;
import com.azure.identity.ManagedIdentityCredentialBuilder;
import com.microsoft.azure.toolkit.lib.auth.Account;
import com.microsoft.azure.toolkit.lib.auth.AuthConfiguration;
import com.microsoft.azure.toolkit.lib.auth.AuthType;
import javax.annotation.Nonnull;

public class ManagedIdentityAccount
extends Account {
    private final AuthType type = AuthType.MANAGED_IDENTITY;

    public ManagedIdentityAccount() {
        super(new AuthConfiguration(AuthType.MANAGED_IDENTITY));
    }

    public ManagedIdentityAccount(@Nonnull AuthConfiguration config) {
        super(config);
    }

    @Override
    @Nonnull
    protected TokenCredential buildDefaultTokenCredential() {
        return new ManagedIdentityCredentialBuilder().clientId(this.getClientId()).build();
    }

    @Override
    public boolean checkAvailable() {
        return this.getManagementToken().isPresent();
    }

    @Override
    public AuthType getType() {
        return this.type;
    }
}

