/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.auth;

import com.azure.core.credential.AccessToken;
import com.azure.core.credential.TokenCredential;
import com.azure.core.credential.TokenRequestContext;
import com.azure.core.http.policy.FixedDelay;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.RetryStrategy;
import com.azure.core.management.AzureEnvironment;
import com.azure.core.management.profile.AzureProfile;
import com.azure.core.util.logging.ClientLogger;
import com.azure.identity.DeviceCodeCredential;
import com.azure.identity.InteractiveBrowserCredential;
import com.azure.identity.TokenCachePersistenceOptions;
import com.azure.identity.implementation.MsalToken;
import com.azure.identity.implementation.util.ScopeUtil;
import com.azure.resourcemanager.resources.ResourceManager;
import com.microsoft.aad.msal4j.IAccount;
import com.microsoft.azure.toolkit.lib.Azure;
import com.microsoft.azure.toolkit.lib.auth.Account$AjcClosure1;
import com.microsoft.azure.toolkit.lib.auth.AuthConfiguration;
import com.microsoft.azure.toolkit.lib.auth.AuthType;
import com.microsoft.azure.toolkit.lib.auth.AzureCloud;
import com.microsoft.azure.toolkit.lib.auth.AzureEnvironmentUtils;
import com.microsoft.azure.toolkit.lib.auth.AzureToolkitAuthenticationException;
import com.microsoft.azure.toolkit.lib.auth.IAccountActions;
import com.microsoft.azure.toolkit.lib.common.bundle.AzureString;
import com.microsoft.azure.toolkit.lib.common.cache.CacheEvict;
import com.microsoft.azure.toolkit.lib.common.cache.CacheManager;
import com.microsoft.azure.toolkit.lib.common.cache.Preloader;
import com.microsoft.azure.toolkit.lib.common.event.AzureEventBus;
import com.microsoft.azure.toolkit.lib.common.exception.AzureToolkitRuntimeException;
import com.microsoft.azure.toolkit.lib.common.messager.AzureMessager;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzServiceSubscription;
import com.microsoft.azure.toolkit.lib.common.model.Subscription;
import com.microsoft.azure.toolkit.lib.common.task.AzureTaskManager;
import com.microsoft.azure.toolkit.lib.common.utils.TextUtils;
import com.microsoft.azure.toolkit.lib.common.utils.Utils;
import java.lang.reflect.Field;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public abstract class Account
implements com.microsoft.azure.toolkit.lib.account.IAccount {
    protected static final TokenCachePersistenceOptions PERSISTENCE_OPTIONS;
    private static final ClientLogger LOGGER;
    private final Map<String, TokenCredential> tenantCredentialCache = new ConcurrentHashMap<String, TokenCredential>();
    @Nonnull
    private final AuthConfiguration config;
    protected String username;
    protected boolean persistenceEnabled = true;
    private TokenCredential defaultTokenCredential;
    private List<Subscription> subscriptions;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    @Nonnull
    protected abstract TokenCredential buildDefaultTokenCredential();

    public TokenCredential getTokenCredential(String subscriptionId) {
        Subscription subscription = this.getSubscription(subscriptionId);
        return this.getTenantTokenCredential(subscription.getTenantId());
    }

    @Nonnull
    public TokenCredential getTenantTokenCredential(@Nonnull String tenantId) {
        if (StringUtils.isBlank((CharSequence)tenantId)) {
            throw new IllegalArgumentException("tenant id is required to retrieve credential.");
        }
        return this.tenantCredentialCache.computeIfAbsent(tenantId, tId -> new TenantTokenCredential((String)tId, this.defaultTokenCredential));
    }

    void login() {
        this.defaultTokenCredential = this.buildDefaultTokenCredential();
        this.reloadSubscriptions();
        this.setupAfterLogin(this.defaultTokenCredential);
        this.config.setType(this.getType());
        this.config.setClient(this.getClientId());
        List<String> tenantIds = this.getTenantIds();
        if (StringUtils.isEmpty((CharSequence)this.config.getTenant())) {
            this.config.setTenant(CollectionUtils.isEmpty(tenantIds) ? null : tenantIds.get(0));
        }
        this.config.setEnvironment(AzureEnvironmentUtils.azureEnvironmentToString(this.getEnvironment()));
        this.config.setUsername(this.getUsername());
    }

    public abstract boolean checkAvailable();

    @Nonnull
    protected Optional<AccessToken> getManagementToken() {
        String[] scopes = ScopeUtil.resourceToScopes((String)this.getEnvironment().getManagementEndpoint());
        TokenRequestContext request = new TokenRequestContext().addScopes(scopes);
        try {
            return this.buildDefaultTokenCredential().getToken(request).onErrorResume(Exception.class, t -> Mono.empty()).blockOptional();
        }
        catch (Throwable t2) {
            return Optional.empty();
        }
    }

    protected void setupAfterLogin(TokenCredential defaultTokenCredential) {
        String[] scopes = ScopeUtil.resourceToScopes((String)this.getEnvironment().getManagementEndpoint());
        TokenRequestContext request = new TokenRequestContext().addScopes(scopes);
        AccessToken token = (AccessToken)defaultTokenCredential.getToken(request).blockOptional().orElseThrow(() -> new AzureToolkitAuthenticationException("Failed to retrieve token."));
        if (token instanceof MsalToken) {
            this.username = Optional.of((MsalToken)token).map(MsalToken::getAccount).map(IAccount::username).orElse(this.getClientId());
        }
        Optional.ofNullable(this.getConfig().getDoAfterLogin()).ifPresent(Runnable::run);
    }

    @CacheEvict(value="<ALL>")
    void logout() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        Account$AjcClosure1 account$AjcClosure1 = new Account$AjcClosure1(objectArray);
        CacheManager.aspectOf().aroundCacheEvict(account$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    public List<Subscription> reloadSubscriptions() {
        List selected = Optional.ofNullable(this.subscriptions).orElse(Collections.emptyList()).stream().filter(Subscription::isSelected).map(Subscription::getId).collect(Collectors.toList());
        this.subscriptions = Optional.ofNullable(this.loadSubscriptions()).orElse(Collections.emptyList()).stream().sorted(Comparator.comparing(s -> s.getName().toLowerCase())).collect(Collectors.toList());
        this.subscriptions.stream().filter(s -> selected.contains(s.getId().toLowerCase())).forEach(s -> s.setSelected(true));
        return this.getSubscriptions();
    }

    protected List<Subscription> loadSubscriptions() {
        TokenCredential credential = this.defaultTokenCredential;
        ResourceManager.Authenticated client = Account.configureAzure().authenticate(credential, new AzureProfile(this.getEnvironment()));
        List tenants = client.tenants().list().stream().collect(Collectors.toList());
        return tenants.stream().flatMap(t -> this.loadSubscriptions(t.tenantId()).stream()).filter(Utils.distinctByKey(Subscription::getId)).collect(Collectors.toList());
    }

    @Nonnull
    private List<Subscription> loadSubscriptions(String tenantId) {
        TokenCredential credential = this.getTenantTokenCredential(tenantId);
        AzureProfile profile = new AzureProfile(tenantId, null, this.getEnvironment());
        ResourceManager.Authenticated client = Account.configureAzure().authenticate(credential, profile);
        List subscriptions = (List)client.subscriptions().listAsync().onErrorResume(ex -> {
            AzureMessager.getMessager().warning(AzureString.format((String)"Failed to get subscriptions for tenant %s, please confirm you have sufficient permissions. Use %s to explicitly login to a tenant if it requires Multi-Factor Authentication (MFA). Message: %s", (Object[])new Object[]{tenantId, "-Dauth.tenant=TENANT_ID", ex.getMessage()}));
            return Flux.fromIterable(new ArrayList());
        }).map(Subscription::new).collect(Collectors.toList()).flatMapIterable(s -> s).collectList().block();
        return Optional.ofNullable(subscriptions).orElse(Collections.emptyList());
    }

    @Nonnull
    public List<Subscription> getSubscriptions() {
        if (!this.isLoggedIn()) {
            String cause = "You are not signed-in or there are no subscriptions in your current Account.";
            throw new AzureToolkitRuntimeException("You are not signed-in or there are no subscriptions in your current Account.", new Object[]{IAccountActions.AUTHENTICATE, IAccountActions.TRY_AZURE});
        }
        return new ArrayList<Subscription>(Optional.ofNullable(this.subscriptions).orElse(Collections.emptyList()));
    }

    public void setSelectedSubscriptions(List<String> selectedSubscriptionIds) {
        if (CollectionUtils.isEmpty(selectedSubscriptionIds)) {
            throw new AzureToolkitRuntimeException("No subscriptions are selected. You must select at least one subscription.", new Object[]{IAccountActions.SELECT_SUBS});
        }
        Set selected = selectedSubscriptionIds.stream().map(String::toLowerCase).collect(Collectors.toSet());
        this.getSubscriptions().forEach(s -> s.setSelected(false));
        this.getSubscriptions().stream().filter(s -> selected.contains(s.getId().toLowerCase())).forEach(s -> s.setSelected(true));
        this.config.setSelectedSubscriptions(selectedSubscriptionIds);
        AzureEventBus.emit((String)"account.subscription_changed.account", (Object)this);
        AzureTaskManager manager = AzureTaskManager.getInstance();
        if (Objects.nonNull(manager)) {
            manager.runOnPooledThread(Preloader::load);
        }
    }

    public Subscription getSubscription(String subscriptionId) {
        return this.getSubscriptions().stream().filter(s -> StringUtils.equalsIgnoreCase((CharSequence)subscriptionId, (CharSequence)s.getId())).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format("Cannot find subscription with id '%s'", subscriptionId)));
    }

    public Subscription getSelectedSubscription(String subscriptionId) {
        return this.getSelectedSubscriptions().stream().filter(s -> StringUtils.equalsIgnoreCase((CharSequence)subscriptionId, (CharSequence)s.getId())).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format("Cannot find a selected subscription with id '%s'", subscriptionId)));
    }

    public List<Subscription> getSelectedSubscriptions() {
        return this.getSubscriptions().stream().filter(Subscription::isSelected).collect(Collectors.toList());
    }

    @Nonnull
    public List<String> getTenantIds() {
        return this.getSubscriptions().stream().map(Subscription::getTenantId).distinct().collect(Collectors.toList());
    }

    public String getPortalUrl() {
        return AzureEnvironmentUtils.getPortalUrl(this.getEnvironment());
    }

    public AzureEnvironment getEnvironment() {
        return ((AzureCloud)Azure.az(AzureCloud.class)).getOrDefault();
    }

    public boolean isLoggedInCompletely() {
        return this.isLoggedIn() && CollectionUtils.isNotEmpty(this.getSelectedSubscriptions());
    }

    public boolean isLoggedIn() {
        return Objects.nonNull(this.defaultTokenCredential) && CollectionUtils.isNotEmpty(this.subscriptions);
    }

    public boolean isSubscriptionsSelected() {
        return this.isLoggedInCompletely();
    }

    @Nullable
    protected TokenCachePersistenceOptions getPersistenceOptions() {
        return this.isPersistenceEnabled() ? PERSISTENCE_OPTIONS : null;
    }

    private static ResourceManager.Configurable configureAzure() {
        String userAgent = Azure.az().config().getUserAgent();
        return (ResourceManager.Configurable)((ResourceManager.Configurable)((ResourceManager.Configurable)ResourceManager.configure().withHttpClient(AbstractAzServiceSubscription.getDefaultHttpClient())).withPolicy(AbstractAzServiceSubscription.getUserAgentPolicy((String)userAgent))).withRetryPolicy(new RetryPolicy((RetryStrategy)new FixedDelay(0, Duration.ofSeconds(0L))));
    }

    public String toString() {
        List<Subscription> selectedSubscriptions;
        ArrayList<String> details = new ArrayList<String>();
        String username = this.getUsername();
        if (this.getType() != null) {
            details.add(String.format("Auth type: %s", TextUtils.cyan((String)this.getType().toString())));
        }
        if (this.isLoggedIn() && CollectionUtils.isNotEmpty(selectedSubscriptions = this.getSelectedSubscriptions()) && selectedSubscriptions.size() == 1) {
            details.add(String.format("Default subscription: %s(%s)", TextUtils.cyan((String)selectedSubscriptions.get(0).getName()), TextUtils.cyan((String)selectedSubscriptions.get(0).getId())));
        }
        if (StringUtils.isNotEmpty((CharSequence)username)) {
            details.add(String.format("Username: %s", TextUtils.cyan((String)username.trim())));
        }
        return StringUtils.join((Object[])details.toArray(), (String)"\n");
    }

    public abstract AuthType getType();

    public String getClientId() {
        return Optional.ofNullable(this.config.getClient()).orElse("04b07795-8ddb-461a-bbee-02f9e1bf7b46");
    }

    public Map<String, TokenCredential> getTenantCredentialCache() {
        return this.tenantCredentialCache;
    }

    @Nonnull
    public AuthConfiguration getConfig() {
        return this.config;
    }

    public String getUsername() {
        return this.username;
    }

    public boolean isPersistenceEnabled() {
        return this.persistenceEnabled;
    }

    public Account(@Nonnull AuthConfiguration config) {
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        this.config = config;
    }

    void setPersistenceEnabled(boolean persistenceEnabled) {
        this.persistenceEnabled = persistenceEnabled;
    }

    TokenCredential getDefaultTokenCredential() {
        return this.defaultTokenCredential;
    }

    static {
        Account.ajc$preClinit();
        PERSISTENCE_OPTIONS = new TokenCachePersistenceOptions().setName("azure-toolkit.cache");
        LOGGER = new ClientLogger(Account.class);
    }

    static final /* synthetic */ void logout_aroundBody0(Account ajc$this, JoinPoint joinPoint) {
        ajc$this.subscriptions = null;
        ajc$this.defaultTokenCredential = null;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("Account.java", Account.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0", "logout", "com.microsoft.azure.toolkit.lib.auth.Account", "", "", "", "void"), 140);
    }

    private static class TenantTokenCredential
    implements TokenCredential {
        private final String tenantId;
        private final TokenCredential defaultCredential;

        public Mono<AccessToken> getToken(TokenRequestContext request) {
            request.setTenantId((String)StringUtils.firstNonBlank((CharSequence[])new String[]{request.getTenantId(), this.tenantId}));
            return this.defaultCredential.getToken(request).doOnTerminate(() -> {
                if (this.defaultCredential instanceof InteractiveBrowserCredential || this.defaultCredential instanceof DeviceCodeCredential) {
                    this.disableAutomaticAuthentication();
                }
            });
        }

        private void disableAutomaticAuthentication() {
            Field automaticField = FieldUtils.getField(this.defaultCredential.getClass(), (String)"automaticAuthentication", (boolean)true);
            if (Objects.nonNull(automaticField) && ((Boolean)FieldUtils.readField((Field)automaticField, (Object)this.defaultCredential)).booleanValue()) {
                FieldUtils.writeField((Field)automaticField, (Object)this.defaultCredential, (Object)false);
            }
        }

        public TenantTokenCredential(String tenantId, TokenCredential defaultCredential) {
            this.tenantId = tenantId;
            this.defaultCredential = defaultCredential;
        }
    }
}

