/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.tools.auth.util;

import com.microsoft.azure.tools.auth.exception.InvalidConfigurationException;
import com.microsoft.azure.tools.auth.model.AuthConfiguration;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class ValidationUtil {
    public static AuthConfiguration validateAuthConfiguration(AuthConfiguration config) throws InvalidConfigurationException {
        String tenant = config.getTenant();
        String client = config.getClient();
        String key = config.getKey();
        String certificate = config.getCertificate();
        String errorMessage = null;
        if (StringUtils.isBlank((CharSequence)tenant)) {
            errorMessage = "Cannot find 'tenant'";
        } else if (StringUtils.isBlank((CharSequence)client)) {
            errorMessage = "Cannot find 'client'";
        } else if (StringUtils.isAllBlank((CharSequence[])new CharSequence[]{key, certificate})) {
            errorMessage = "Cannot find either 'key' or 'certificate'";
        } else if (StringUtils.isNotBlank((CharSequence)key) && StringUtils.isNotBlank((CharSequence)certificate)) {
            errorMessage = "It is wrong to specify both 'key' and 'certificate'";
        }
        if (Objects.nonNull(errorMessage)) {
            throw new InvalidConfigurationException(errorMessage);
        }
        return config;
    }
}

