/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.tools.auth.core.vscode;

import com.azure.core.credential.TokenCredential;
import com.azure.identity.VisualStudioCodeCredential;
import com.azure.identity.VisualStudioCodeCredentialBuilder;
import com.google.common.base.MoreObjects;
import com.microsoft.azure.AzureEnvironment;
import com.microsoft.azure.tools.auth.core.AbstractCredentialRetriever;
import com.microsoft.azure.tools.auth.core.vscode.VisualStudioCodeAccountProfile;
import com.microsoft.azure.tools.auth.core.vscode.VisualStudioCodeProfileRetriever;
import com.microsoft.azure.tools.auth.exception.InvalidConfigurationException;
import com.microsoft.azure.tools.auth.exception.LoginFailureException;
import com.microsoft.azure.tools.auth.model.AuthMethod;
import com.microsoft.azure.tools.auth.model.AzureCredentialWrapper;
import com.microsoft.azure.tools.auth.util.AzureEnvironmentUtils;
import java.util.Objects;

public class VisualStudioCodeCredentialRetriever
extends AbstractCredentialRetriever {
    private AzureEnvironment envFromVscode;

    public VisualStudioCodeCredentialRetriever(AzureEnvironment env) {
        super(env);
    }

    @Override
    public AzureCredentialWrapper retrieveInternal() throws LoginFailureException {
        try {
            VisualStudioCodeAccountProfile vscodeProfile = VisualStudioCodeProfileRetriever.getProfile(this.getAzureEnvironment());
            this.envFromVscode = AzureEnvironmentUtils.stringToAzureEnvironment(vscodeProfile.getEnvironment());
            VisualStudioCodeCredentialRetriever.checkAzureEnvironmentConflict(this.env, this.envFromVscode);
            AzureEnvironmentUtils.setupAzureEnvironment(this.envFromVscode);
            VisualStudioCodeCredential visualStudioCodeCredential = new VisualStudioCodeCredentialBuilder().build();
            this.validateTokenCredential((TokenCredential)visualStudioCodeCredential);
            return new AzureCredentialWrapper(AuthMethod.VSCODE, (TokenCredential)visualStudioCodeCredential, (AzureEnvironment)MoreObjects.firstNonNull((Object)this.envFromVscode, (Object)AzureEnvironment.AZURE)).withFilteredSubscriptionIds(vscodeProfile.getFilteredSubscriptions());
        }
        catch (InvalidConfigurationException e) {
            throw new LoginFailureException("Cannot get azure profile from VSCode, please make sure that you have signed-in in VSCode Azure Account plugin, detailed messages is: %s");
        }
    }

    private static void checkAzureEnvironmentConflict(AzureEnvironment env, AzureEnvironment envVSCode) throws LoginFailureException {
        if (env != null && envVSCode != null && !Objects.equals(env, envVSCode)) {
            throw new LoginFailureException(String.format("The azure cloud from vscode '%s' doesn't match with your auth configuration: %s, you can change it by pressing F1 in VSCode and find \">azure: sign in to Azure Cloud\" command to change azure cloud in vscode.", AzureEnvironmentUtils.azureEnvironmentToString(envVSCode), AzureEnvironmentUtils.azureEnvironmentToString(env)));
        }
    }

    @Override
    protected AzureEnvironment getAzureEnvironment() {
        return (AzureEnvironment)MoreObjects.firstNonNull((Object)this.envFromVscode, (Object)AzureEnvironment.AZURE);
    }
}

