/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.tools.auth.core;

import com.microsoft.azure.tools.auth.core.ICredentialRetriever;
import com.microsoft.azure.tools.auth.exception.AzureLoginException;
import com.microsoft.azure.tools.auth.model.AzureCredentialWrapper;
import java.util.ArrayList;
import java.util.List;
import rx.Single;

public class ChainedCredentialRetriever
implements ICredentialRetriever {
    private List<Single<AzureCredentialWrapper>> retrieveFunctions = new ArrayList<Single<AzureCredentialWrapper>>();

    public void addRetriever(ICredentialRetriever credentialRetriever) {
        this.retrieveFunctions.add(credentialRetriever.retrieve());
    }

    @Override
    public Single<AzureCredentialWrapper> retrieve() {
        if (this.retrieveFunctions.isEmpty()) {
            return Single.error((Throwable)new AzureLoginException("No retrievers are defined to get azure credentials."));
        }
        Single function = this.retrieveFunctions.get(0);
        for (int i = 1; i < this.retrieveFunctions.size(); ++i) {
            function = function.onErrorResumeNext(this.retrieveFunctions.get(i));
        }
        return function;
    }
}

