/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.tools.auth.core;

import com.azure.core.credential.AccessToken;
import com.azure.core.credential.TokenCredential;
import com.azure.core.credential.TokenRequestContext;
import com.azure.core.exception.ClientAuthenticationException;
import com.google.common.base.MoreObjects;
import com.microsoft.azure.AzureEnvironment;
import com.microsoft.azure.tools.auth.core.ICredentialRetriever;
import com.microsoft.azure.tools.auth.exception.LoginFailureException;
import com.microsoft.azure.tools.auth.model.AzureCredentialWrapper;
import rx.Single;

public abstract class AbstractCredentialRetriever
implements ICredentialRetriever {
    protected AzureEnvironment env;

    public AbstractCredentialRetriever(AzureEnvironment env) {
        this.env = env;
    }

    @Override
    public Single<AzureCredentialWrapper> retrieve() {
        return Single.fromCallable(this::retrieveInternal);
    }

    public abstract AzureCredentialWrapper retrieveInternal() throws LoginFailureException;

    protected void validateTokenCredential(TokenCredential credential) throws LoginFailureException {
        try {
            ((AccessToken)credential.getToken(new TokenRequestContext().addScopes(new String[]{this.getAzureEnvironment().managementEndpoint() + "/.default"})).block()).getToken();
        }
        catch (ClientAuthenticationException ex) {
            throw new LoginFailureException(ex.getMessage(), ex);
        }
    }

    protected AzureEnvironment getAzureEnvironment() {
        return (AzureEnvironment)MoreObjects.firstNonNull((Object)this.env, (Object)AzureEnvironment.AZURE);
    }

    public void setEnv(AzureEnvironment env) {
        this.env = env;
    }
}

