/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkits.appservice.utils;

import com.azure.resourcemanager.appservice.models.AppSetting;
import com.microsoft.azure.toolkit.lib.common.exception.AzureToolkitRuntimeException;
import com.microsoft.azure.toolkits.appservice.model.DeployType;
import java.io.File;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class Utils {
    private static final String SUBSCRIPTIONS = "subscriptions";

    public static Map<String, String> normalizeAppSettings(Map<String, AppSetting> input) {
        return input.entrySet().stream().collect(Collectors.toMap(entry -> (String)entry.getKey(), entry -> ((AppSetting)entry.getValue()).value()));
    }

    public static String getSegment(String id, String segment) {
        if (StringUtils.isEmpty((CharSequence)id)) {
            return null;
        }
        Object[] attributes = StringUtils.lowerCase((String)id).split("/");
        int pos = ArrayUtils.indexOf((Object[])attributes, (Object)StringUtils.lowerCase((String)segment));
        if (pos >= 0) {
            return attributes[pos + 1];
        }
        return null;
    }

    public static String getSubscriptionId(String resourceId) {
        return Utils.getSegment(resourceId, SUBSCRIPTIONS);
    }

    public static DeployType getDeployTypeByFileExtension(File file) {
        String fileExtensionName = FilenameUtils.getExtension((String)file.getName());
        switch (StringUtils.lowerCase((String)fileExtensionName)) {
            case "jar": {
                return DeployType.JAR;
            }
            case "war": {
                return DeployType.WAR;
            }
            case "ear": {
                return DeployType.EAR;
            }
            case "zip": {
                return DeployType.ZIP;
            }
        }
        throw new AzureToolkitRuntimeException("Unsupported file type, please set the deploy type.");
    }
}

