/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkits.appservice.service.impl;

import com.azure.core.management.exception.ManagementException;
import com.azure.resourcemanager.AzureResourceManager;
import com.azure.resourcemanager.appservice.models.DeployOptions;
import com.azure.resourcemanager.appservice.models.DeploymentSlot;
import com.azure.resourcemanager.appservice.models.WebApp;
import com.azure.resourcemanager.appservice.models.WebAppBase;
import com.microsoft.azure.toolkit.lib.common.exception.AzureToolkitRuntimeException;
import com.microsoft.azure.toolkits.appservice.AzureAppService;
import com.microsoft.azure.toolkits.appservice.entity.WebAppDeploymentSlotEntity;
import com.microsoft.azure.toolkits.appservice.model.DeployType;
import com.microsoft.azure.toolkits.appservice.model.PublishingProfile;
import com.microsoft.azure.toolkits.appservice.model.Runtime;
import com.microsoft.azure.toolkits.appservice.service.IWebApp;
import com.microsoft.azure.toolkits.appservice.service.IWebAppDeploymentSlot;
import com.microsoft.azure.toolkits.appservice.service.IWebAppDeploymentSlotCreator;
import com.microsoft.azure.toolkits.appservice.service.impl.AppServiceUtils;
import java.io.File;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class WebAppDeploymentSlot
implements IWebAppDeploymentSlot {
    private AzureAppService azureAppService;
    private WebAppDeploymentSlotEntity slotEntity;
    private DeploymentSlot deploymentSlotInner;
    private AzureResourceManager azureClient;

    public WebAppDeploymentSlot(WebAppDeploymentSlotEntity deploymentSlot, AzureAppService azureAppService) {
        this.slotEntity = deploymentSlot;
        this.azureAppService = azureAppService;
        this.azureClient = azureAppService.getAzureResourceManager();
    }

    @Override
    public IWebApp webApp() {
        WebAppDeploymentSlotEntity entity = this.entity();
        return this.azureAppService.webapp(entity.getResourceGroup(), entity.getWebappName());
    }

    @Override
    public IWebAppDeploymentSlotCreator create() {
        return new WebAppDeploymentSlotCreator();
    }

    @Override
    public void start() {
        this.getDeploymentSlotInner().start();
    }

    @Override
    public void stop() {
        this.getDeploymentSlotInner().stop();
    }

    @Override
    public void restart() {
        this.getDeploymentSlotInner().restart();
    }

    @Override
    public void delete() {
        ((WebApp)this.getDeploymentSlotInner().parent()).deploymentSlots().deleteByName(this.slotEntity.getName());
    }

    @Override
    public void deploy(DeployType deployType, File targetFile, String targetPath) {
        DeployOptions options = new DeployOptions().withPath(targetPath);
        this.getDeploymentSlotInner().deploy(com.azure.resourcemanager.appservice.models.DeployType.fromString((String)deployType.getValue()), targetFile, options);
    }

    @Override
    public boolean exists() {
        this.refreshDeploymentSlotInner();
        return this.deploymentSlotInner != null;
    }

    @Override
    public String hostName() {
        return this.getDeploymentSlotInner().defaultHostname();
    }

    @Override
    public String state() {
        return this.getDeploymentSlotInner().state();
    }

    @Override
    public Runtime getRuntime() {
        return AppServiceUtils.getRuntimeFromWebApp((WebAppBase)this.getDeploymentSlotInner());
    }

    @Override
    public PublishingProfile getPublishingProfile() {
        return AppServiceUtils.fromPublishingProfile(this.getDeploymentSlotInner().getPublishingProfile());
    }

    @Override
    public WebAppDeploymentSlotEntity entity() {
        return this.slotEntity;
    }

    private DeploymentSlot getDeploymentSlotInner() {
        if (this.deploymentSlotInner == null) {
            this.refreshDeploymentSlotInner();
        }
        return this.deploymentSlotInner;
    }

    private synchronized void refreshDeploymentSlotInner() {
        try {
            WebApp webAppService = StringUtils.isNotEmpty((CharSequence)this.slotEntity.getId()) ? (WebApp)this.azureClient.webApps().getById(this.slotEntity.getId().substring(0, this.slotEntity.getId().indexOf("/slots"))) : (WebApp)this.azureClient.webApps().getByResourceGroup(this.slotEntity.getResourceGroup(), this.slotEntity.getWebappName());
            this.deploymentSlotInner = StringUtils.isNotEmpty((CharSequence)this.slotEntity.getId()) ? (DeploymentSlot)webAppService.deploymentSlots().getById(this.slotEntity.getId()) : (DeploymentSlot)webAppService.deploymentSlots().getByName(this.slotEntity.getName());
            this.slotEntity = AppServiceUtils.fromWebAppDeploymentSlot(this.deploymentSlotInner);
        }
        catch (ManagementException e) {
            this.deploymentSlotInner = null;
        }
    }

    @Override
    public String id() {
        return this.getDeploymentSlotInner().id();
    }

    @Override
    public String name() {
        return this.getDeploymentSlotInner().name();
    }

    public class WebAppDeploymentSlotCreator
    implements IWebAppDeploymentSlotCreator {
        public static final String CONFIGURATION_SOURCE_NEW = "new";
        public static final String CONFIGURATION_SOURCE_PARENT = "parent";
        private static final String CONFIGURATION_SOURCE_DOES_NOT_EXISTS = "Target slot configuration source does not exists in current web app";
        private String name;
        private String configurationSource = "parent";
        private Optional<Map<String, String>> appSettings = null;

        @Override
        public IWebAppDeploymentSlotCreator withName(String name) {
            this.name = name;
            return this;
        }

        @Override
        public IWebAppDeploymentSlotCreator withAppSettings(Map<String, String> appSettings) {
            this.appSettings = Optional.ofNullable(appSettings);
            return this;
        }

        @Override
        public IWebAppDeploymentSlotCreator withConfigurationSource(String configurationSource) {
            this.configurationSource = configurationSource;
            return this;
        }

        @Override
        public WebAppDeploymentSlot commit() {
            DeploymentSlot.DefinitionStages.WithCreate withCreate;
            String source;
            WebAppDeploymentSlotEntity entity = WebAppDeploymentSlot.this.entity();
            WebApp webApp = (WebApp)WebAppDeploymentSlot.this.azureClient.webApps().getByResourceGroup(entity.getResourceGroup(), entity.getWebappName());
            DeploymentSlot.DefinitionStages.Blank blank = (DeploymentSlot.DefinitionStages.Blank)webApp.deploymentSlots().define(this.getName());
            switch (source = StringUtils.isEmpty((CharSequence)this.configurationSource) ? CONFIGURATION_SOURCE_PARENT : StringUtils.lowerCase((String)this.configurationSource)) {
                case "new": {
                    withCreate = blank.withBrandNewConfiguration();
                    break;
                }
                case "parent": {
                    withCreate = blank.withConfigurationFromParent();
                    break;
                }
                default: {
                    DeploymentSlot deploymentSlot = (DeploymentSlot)((WebApp)WebAppDeploymentSlot.this.deploymentSlotInner.parent()).deploymentSlots().getByName(this.configurationSource);
                    if (deploymentSlot == null) {
                        throw new AzureToolkitRuntimeException(CONFIGURATION_SOURCE_DOES_NOT_EXISTS);
                    }
                    withCreate = blank.withConfigurationFromDeploymentSlot(deploymentSlot);
                }
            }
            if (this.appSettings != null && this.appSettings.isPresent()) {
                withCreate.withAppSettings(this.appSettings.get());
            }
            WebAppDeploymentSlot.this.deploymentSlotInner = (DeploymentSlot)withCreate.create();
            WebAppDeploymentSlot.this.slotEntity = AppServiceUtils.fromWebAppDeploymentSlot(WebAppDeploymentSlot.this.deploymentSlotInner);
            return WebAppDeploymentSlot.this;
        }

        public String getName() {
            return this.name;
        }

        public String getConfigurationSource() {
            return this.configurationSource;
        }

        public Optional<Map<String, String>> getAppSettings() {
            return this.appSettings;
        }
    }
}

