/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkits.appservice.service.impl;

import com.azure.core.management.exception.ManagementException;
import com.azure.resourcemanager.AzureResourceManager;
import com.azure.resourcemanager.appservice.models.AppServicePlan;
import com.azure.resourcemanager.appservice.models.DeployOptions;
import com.azure.resourcemanager.appservice.models.PublishingProfile;
import com.azure.resourcemanager.appservice.models.WebApp;
import com.azure.resourcemanager.appservice.models.WebAppBase;
import com.azure.resourcemanager.resources.models.ResourceGroup;
import com.microsoft.azure.toolkit.lib.common.exception.AzureToolkitRuntimeException;
import com.microsoft.azure.toolkits.appservice.AzureAppService;
import com.microsoft.azure.toolkits.appservice.entity.AppServicePlanEntity;
import com.microsoft.azure.toolkits.appservice.entity.WebAppDeploymentSlotEntity;
import com.microsoft.azure.toolkits.appservice.entity.WebAppEntity;
import com.microsoft.azure.toolkits.appservice.model.DeployType;
import com.microsoft.azure.toolkits.appservice.model.DockerConfiguration;
import com.microsoft.azure.toolkits.appservice.model.Runtime;
import com.microsoft.azure.toolkits.appservice.service.AbstractAppServiceCreator;
import com.microsoft.azure.toolkits.appservice.service.AbstractAppServiceUpdater;
import com.microsoft.azure.toolkits.appservice.service.IAppServicePlan;
import com.microsoft.azure.toolkits.appservice.service.IWebApp;
import com.microsoft.azure.toolkits.appservice.service.IWebAppDeploymentSlot;
import com.microsoft.azure.toolkits.appservice.service.impl.AppServiceUtils;
import com.microsoft.azure.toolkits.appservice.service.impl.WebAppDeploymentSlot;
import java.io.File;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class WebApp
implements IWebApp {
    private static final String UNSUPPORTED_OPERATING_SYSTEM = "Unsupported operating system %s";
    private WebAppEntity entity;
    private AzureAppService azureAppService;
    private AzureResourceManager azureClient;
    private com.azure.resourcemanager.appservice.models.WebApp webAppInner;

    public WebApp(WebAppEntity entity, AzureAppService azureAppService) {
        this.entity = entity;
        this.azureAppService = azureAppService;
        this.azureClient = azureAppService.getAzureResourceManager();
    }

    @Override
    public WebAppEntity entity() {
        return this.entity;
    }

    @Override
    public IAppServicePlan plan() {
        return this.azureAppService.appServicePlan(this.getWebAppInner().appServicePlanId());
    }

    public WebAppCreator create() {
        return new WebAppCreator();
    }

    @Override
    public void start() {
        this.getWebAppInner().start();
    }

    @Override
    public void stop() {
        this.getWebAppInner().stop();
    }

    @Override
    public void restart() {
        this.getWebAppInner().restart();
    }

    @Override
    public void delete() {
        this.azureClient.webApps().deleteById(this.getWebAppInner().id());
    }

    @Override
    public void deploy(DeployType deployType, File targetFile, String targetPath) {
        DeployOptions options = new DeployOptions().withPath(targetPath);
        this.getWebAppInner().deploy(com.azure.resourcemanager.appservice.models.DeployType.fromString((String)deployType.getValue()), targetFile, options);
    }

    @Override
    public boolean exists() {
        this.refreshWebAppInner();
        return this.webAppInner != null;
    }

    @Override
    public String hostName() {
        return this.getWebAppInner().defaultHostname();
    }

    @Override
    public String state() {
        return this.getWebAppInner().state();
    }

    @Override
    public com.microsoft.azure.toolkits.appservice.model.PublishingProfile getPublishingProfile() {
        PublishingProfile publishingProfile = this.getWebAppInner().getPublishingProfile();
        return com.microsoft.azure.toolkits.appservice.model.PublishingProfile.createFromServiceModel(publishingProfile);
    }

    @Override
    public Runtime getRuntime() {
        return AppServiceUtils.getRuntimeFromWebApp((WebAppBase)this.getWebAppInner());
    }

    public WebAppUpdater update() {
        return new WebAppUpdater();
    }

    @Override
    public IWebAppDeploymentSlot deploymentSlot(String slotName) {
        Object slotEntity = ((WebAppDeploymentSlotEntity.WebAppDeploymentSlotEntityBuilder)((WebAppDeploymentSlotEntity.WebAppDeploymentSlotEntityBuilder)((WebAppDeploymentSlotEntity.WebAppDeploymentSlotEntityBuilder)WebAppDeploymentSlotEntity.builder().name(slotName)).resourceGroup(this.getWebAppInner().resourceGroupName())).webappName(this.getWebAppInner().name())).build();
        return new WebAppDeploymentSlot((WebAppDeploymentSlotEntity)slotEntity, this.azureAppService);
    }

    @Override
    public List<IWebAppDeploymentSlot> deploymentSlots() {
        return this.getWebAppInner().deploymentSlots().list().stream().map(slot -> new WebAppDeploymentSlot((WebAppDeploymentSlotEntity)((WebAppDeploymentSlotEntity.WebAppDeploymentSlotEntityBuilder)WebAppDeploymentSlotEntity.builder().id(slot.id())).build(), this.azureAppService)).collect(Collectors.toList());
    }

    private com.azure.resourcemanager.appservice.models.WebApp getWebAppInner() {
        if (this.webAppInner == null) {
            this.refreshWebAppInner();
        }
        return this.webAppInner;
    }

    synchronized void refreshWebAppInner() {
        try {
            this.webAppInner = StringUtils.isNotEmpty((CharSequence)this.entity.getId()) ? (com.azure.resourcemanager.appservice.models.WebApp)this.azureClient.webApps().getById(this.entity.getId()) : (com.azure.resourcemanager.appservice.models.WebApp)this.azureClient.webApps().getByResourceGroup(this.entity.getResourceGroup(), this.entity.getName());
            this.entity = AppServiceUtils.fromWebApp((WebAppBase)this.webAppInner);
        }
        catch (ManagementException e) {
            this.webAppInner = null;
        }
    }

    @Override
    public String id() {
        return this.getWebAppInner().id();
    }

    @Override
    public String name() {
        return this.getWebAppInner().name();
    }

    public class WebAppUpdater
    extends AbstractAppServiceUpdater<WebApp> {
        public static final String CAN_NOT_UPDATE_EXISTING_APP_SERVICE_OS = "Can not update the operation system for existing app service";
        private boolean modified = false;

        public WebApp commit() {
            WebApp.Update update = (WebApp.Update)WebApp.this.getWebAppInner().update();
            if (this.getAppServicePlan() != null && this.getAppServicePlan().isPresent()) {
                update = this.updateAppServicePlan(update, this.getAppServicePlan().get());
            }
            if (this.getRuntime() != null && this.getRuntime().isPresent()) {
                update = this.updateRuntime(update, this.getRuntime().get());
            }
            if (this.getAppSettings() != null && this.getAppSettings().isPresent()) {
                this.modified = true;
                update.withAppSettings(this.getAppSettings().get());
            }
            if (this.modified) {
                WebApp.this.webAppInner = (com.azure.resourcemanager.appservice.models.WebApp)update.apply();
            }
            WebApp.this.entity = AppServiceUtils.fromWebApp((WebAppBase)WebApp.this.webAppInner);
            return WebApp.this;
        }

        private WebApp.Update updateAppServicePlan(WebApp.Update update, AppServicePlanEntity newServicePlan) {
            AppServicePlanEntity currentServicePlan = WebApp.this.azureAppService.appServicePlan(WebApp.this.getWebAppInner().appServicePlanId()).entity();
            if (StringUtils.equalsIgnoreCase((CharSequence)currentServicePlan.getId(), (CharSequence)newServicePlan.getId()) || StringUtils.equalsIgnoreCase((CharSequence)currentServicePlan.getName(), (CharSequence)newServicePlan.getName()) && StringUtils.equalsIgnoreCase((CharSequence)currentServicePlan.getResourceGroup(), (CharSequence)newServicePlan.getResourceGroup())) {
                return update;
            }
            AppServicePlan newPlanServiceModel = AppServiceUtils.getAppServicePlan(newServicePlan, WebApp.this.azureClient);
            if (newPlanServiceModel == null) {
                throw new AzureToolkitRuntimeException("Target app service plan not exists");
            }
            this.modified = true;
            return update.withExistingAppServicePlan(newPlanServiceModel);
        }

        private WebApp.Update updateRuntime(WebApp.Update update, Runtime newRuntime) {
            Runtime current = WebApp.this.getRuntime();
            if (Objects.equals(current, newRuntime)) {
                return update;
            }
            if (current.getOperatingSystem() != newRuntime.getOperatingSystem()) {
                throw new AzureToolkitRuntimeException(CAN_NOT_UPDATE_EXISTING_APP_SERVICE_OS);
            }
            this.modified = true;
            switch (newRuntime.getOperatingSystem()) {
                case LINUX: {
                    return update.withBuiltInImage(AppServiceUtils.toLinuxRuntimeStack(newRuntime));
                }
                case WINDOWS: {
                    return (WebApp.Update)update.withJavaVersion(AppServiceUtils.toWindowsJavaVersion(newRuntime)).withWebContainer(AppServiceUtils.toWindowsWebContainer(newRuntime));
                }
                case DOCKER: {
                    DockerConfiguration dockerConfiguration = this.getDockerConfiguration().get();
                    if (StringUtils.isAllEmpty((CharSequence[])new CharSequence[]{dockerConfiguration.getUserName(), dockerConfiguration.getPassword()})) {
                        return update.withPublicDockerHubImage(dockerConfiguration.getImage());
                    }
                    if (StringUtils.isEmpty((CharSequence)dockerConfiguration.getRegistryUrl())) {
                        return update.withPrivateDockerHubImage(dockerConfiguration.getImage()).withCredentials(dockerConfiguration.getUserName(), dockerConfiguration.getPassword());
                    }
                    return update.withPrivateRegistryImage(dockerConfiguration.getImage(), dockerConfiguration.getRegistryUrl()).withCredentials(dockerConfiguration.getUserName(), dockerConfiguration.getPassword());
                }
            }
            throw new AzureToolkitRuntimeException(String.format(WebApp.UNSUPPORTED_OPERATING_SYSTEM, new Object[]{newRuntime.getOperatingSystem()}));
        }
    }

    public class WebAppCreator
    extends AbstractAppServiceCreator<WebApp> {
        @Override
        public WebApp commit() {
            WebApp.DefinitionStages.WithCreate withCreate;
            WebApp.DefinitionStages.Blank blank = (WebApp.DefinitionStages.Blank)WebApp.this.azureClient.webApps().define(this.getName());
            Runtime runtime = this.getRuntime();
            AppServicePlan appServicePlan = AppServiceUtils.getAppServicePlan(this.getAppServicePlanEntity(), WebApp.this.azureClient);
            ResourceGroup resourceGroup = (ResourceGroup)WebApp.this.azureClient.resourceGroups().getByName(this.getResourceGroup());
            switch (runtime.getOperatingSystem()) {
                case LINUX: {
                    withCreate = this.createLinuxWebApp(blank, resourceGroup, appServicePlan, runtime);
                    break;
                }
                case WINDOWS: {
                    withCreate = this.createWindowsWebApp(blank, resourceGroup, appServicePlan, runtime);
                    break;
                }
                case DOCKER: {
                    DockerConfiguration dockerConfiguration = this.getDockerConfiguration().get();
                    withCreate = this.createDockerWebApp(blank, resourceGroup, appServicePlan, dockerConfiguration);
                    break;
                }
                default: {
                    throw new AzureToolkitRuntimeException(String.format(WebApp.UNSUPPORTED_OPERATING_SYSTEM, new Object[]{runtime.getOperatingSystem()}));
                }
            }
            if (this.getAppSettings() != null && this.getAppSettings().isPresent()) {
                withCreate.withAppSettings(this.getAppSettings().get());
            }
            WebApp.this.webAppInner = (com.azure.resourcemanager.appservice.models.WebApp)withCreate.create();
            WebApp.this.entity = AppServiceUtils.fromWebApp((WebAppBase)WebApp.this.webAppInner);
            return WebApp.this;
        }

        WebApp.DefinitionStages.WithCreate createWindowsWebApp(WebApp.DefinitionStages.Blank blank, ResourceGroup resourceGroup, AppServicePlan appServicePlan, Runtime runtime) {
            return (WebApp.DefinitionStages.WithCreate)blank.withExistingWindowsPlan(appServicePlan).withExistingResourceGroup(resourceGroup).withJavaVersion(AppServiceUtils.toWindowsJavaVersion(runtime)).withWebContainer(AppServiceUtils.toWindowsWebContainer(runtime));
        }

        WebApp.DefinitionStages.WithCreate createLinuxWebApp(WebApp.DefinitionStages.Blank blank, ResourceGroup resourceGroup, AppServicePlan appServicePlan, Runtime runtime) {
            return blank.withExistingLinuxPlan(appServicePlan).withExistingResourceGroup(resourceGroup).withBuiltInImage(AppServiceUtils.toLinuxRuntimeStack(runtime));
        }

        WebApp.DefinitionStages.WithCreate createDockerWebApp(WebApp.DefinitionStages.Blank blank, ResourceGroup resourceGroup, AppServicePlan appServicePlan, DockerConfiguration dockerConfiguration) {
            WebApp.DefinitionStages.WithLinuxAppFramework withLinuxAppFramework = blank.withExistingLinuxPlan(appServicePlan).withExistingResourceGroup(resourceGroup);
            if (StringUtils.isAllEmpty((CharSequence[])new CharSequence[]{dockerConfiguration.getUserName(), dockerConfiguration.getPassword()})) {
                return withLinuxAppFramework.withPublicDockerHubImage(dockerConfiguration.getImage());
            }
            if (StringUtils.isEmpty((CharSequence)dockerConfiguration.getRegistryUrl())) {
                return withLinuxAppFramework.withPrivateDockerHubImage(dockerConfiguration.getImage()).withCredentials(dockerConfiguration.getUserName(), dockerConfiguration.getPassword());
            }
            return withLinuxAppFramework.withPrivateRegistryImage(dockerConfiguration.getImage(), dockerConfiguration.getRegistryUrl()).withCredentials(dockerConfiguration.getUserName(), dockerConfiguration.getPassword());
        }
    }
}

