/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkits.appservice.service.impl;

import com.azure.core.management.exception.ManagementException;
import com.azure.resourcemanager.AzureResourceManager;
import com.azure.resourcemanager.appservice.models.AppServicePlan;
import com.azure.resourcemanager.appservice.models.DeploymentSlot;
import com.azure.resourcemanager.appservice.models.OperatingSystem;
import com.azure.resourcemanager.appservice.models.PricingTier;
import com.azure.resourcemanager.appservice.models.PublishingProfile;
import com.azure.resourcemanager.appservice.models.RuntimeStack;
import com.azure.resourcemanager.appservice.models.SkuDescription;
import com.azure.resourcemanager.appservice.models.WebApp;
import com.azure.resourcemanager.appservice.models.WebAppBase;
import com.azure.resourcemanager.appservice.models.WebAppBasic;
import com.microsoft.azure.toolkits.appservice.entity.AppServicePlanEntity;
import com.microsoft.azure.toolkits.appservice.entity.WebAppDeploymentSlotEntity;
import com.microsoft.azure.toolkits.appservice.entity.WebAppEntity;
import com.microsoft.azure.toolkits.appservice.model.JavaVersion;
import com.microsoft.azure.toolkits.appservice.model.PublishingProfile;
import com.microsoft.azure.toolkits.appservice.model.Runtime;
import com.microsoft.azure.toolkits.appservice.model.WebContainer;
import com.microsoft.azure.toolkits.appservice.utils.Utils;
import com.microsoft.azure.tools.common.model.Region;
import java.util.Arrays;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

class AppServiceUtils {
    AppServiceUtils() {
    }

    static Runtime getRuntimeFromWebApp(WebAppBase webAppBase) {
        if (StringUtils.startsWithIgnoreCase((CharSequence)webAppBase.linuxFxVersion(), (CharSequence)"docker")) {
            return Runtime.DOCKER;
        }
        return webAppBase.operatingSystem() == OperatingSystem.WINDOWS ? AppServiceUtils.getRuntimeFromWindowsWebApp(webAppBase) : AppServiceUtils.getRuntimeFromLinuxWebApp(webAppBase);
    }

    private static Runtime getRuntimeFromLinuxWebApp(WebAppBase webAppBase) {
        if (StringUtils.isEmpty((CharSequence)webAppBase.linuxFxVersion())) {
            return null;
        }
        String linuxFxVersion = webAppBase.linuxFxVersion().replace("|", " ");
        return Runtime.getRuntimeFromLinuxFxVersion(linuxFxVersion);
    }

    private static Runtime getRuntimeFromWindowsWebApp(WebAppBase webAppBase) {
        if (webAppBase.javaVersion() == null || StringUtils.isAnyEmpty((CharSequence[])new CharSequence[]{webAppBase.javaContainer(), webAppBase.javaContainerVersion()})) {
            return null;
        }
        JavaVersion javaVersion = JavaVersion.values().stream().filter(version -> StringUtils.equals((CharSequence)webAppBase.javaVersion().toString(), (CharSequence)version.getValue())).findFirst().orElse(null);
        String javaContainer = String.join((CharSequence)webAppBase.javaContainer(), " ", webAppBase.javaContainerVersion());
        WebContainer webContainer = StringUtils.equalsIgnoreCase((CharSequence)webAppBase.javaContainer(), (CharSequence)"java") ? WebContainer.JAVA_SE : (WebContainer)WebContainer.values().stream().filter(container -> StringUtils.equalsIgnoreCase((CharSequence)javaContainer, (CharSequence)container.getValue())).findFirst().orElse(null);
        return Runtime.getRuntime(com.microsoft.azure.toolkits.appservice.model.OperatingSystem.WINDOWS, webContainer, javaVersion);
    }

    static RuntimeStack toLinuxRuntimeStack(Runtime runtime) {
        return RuntimeStack.getAll().stream().filter(runtimeStack -> {
            Runtime stackRuntime = Runtime.getRuntimeFromLinuxFxVersion(runtimeStack.toString());
            return stackRuntime != null && Objects.equals(stackRuntime.getJavaVersion(), runtime.getJavaVersion()) && Objects.equals(stackRuntime.getWebContainer(), runtime.getWebContainer());
        }).findFirst().orElse(null);
    }

    static com.azure.resourcemanager.appservice.models.WebContainer toWindowsWebContainer(Runtime runtime) {
        if (runtime.getWebContainer() == WebContainer.JAVA_SE) {
            return StringUtils.startsWith((CharSequence)runtime.getJavaVersion().getValue(), (CharSequence)JavaVersion.JAVA_8.getValue()) ? com.azure.resourcemanager.appservice.models.WebContainer.JAVA_8 : com.azure.resourcemanager.appservice.models.WebContainer.fromString((String)"java 11");
        }
        return com.azure.resourcemanager.appservice.models.WebContainer.values().stream().filter(container -> StringUtils.equalsIgnoreCase((CharSequence)container.toString(), (CharSequence)runtime.getWebContainer().getValue())).findFirst().orElse(null);
    }

    static com.azure.resourcemanager.appservice.models.JavaVersion toWindowsJavaVersion(Runtime runtime) {
        return com.azure.resourcemanager.appservice.models.JavaVersion.values().stream().filter(serviceVersion -> StringUtils.equalsIgnoreCase((CharSequence)serviceVersion.toString(), (CharSequence)runtime.getJavaVersion().getValue())).findFirst().orElse(null);
    }

    static com.microsoft.azure.toolkits.appservice.model.PublishingProfile fromPublishingProfile(PublishingProfile publishingProfile) {
        return ((PublishingProfile.PublishingProfileBuilder)((PublishingProfile.PublishingProfileBuilder)((PublishingProfile.PublishingProfileBuilder)((PublishingProfile.PublishingProfileBuilder)((PublishingProfile.PublishingProfileBuilder)((PublishingProfile.PublishingProfileBuilder)com.microsoft.azure.toolkits.appservice.model.PublishingProfile.builder().ftpUrl(publishingProfile.ftpUrl())).ftpUsername(publishingProfile.ftpUsername())).ftpPassword(publishingProfile.ftpPassword())).gitUrl(publishingProfile.gitUrl())).gitUsername(publishingProfile.gitUsername())).gitPassword(publishingProfile.gitPassword())).build();
    }

    static PricingTier toPricingTier(com.microsoft.azure.toolkits.appservice.model.PricingTier pricingTier) {
        SkuDescription skuDescription = new SkuDescription().withTier(pricingTier.getTier()).withSize(pricingTier.getSize());
        return PricingTier.fromSkuDescription((SkuDescription)skuDescription);
    }

    static com.microsoft.azure.toolkits.appservice.model.PricingTier fromPricingTier(PricingTier pricingTier) {
        return com.microsoft.azure.toolkits.appservice.model.PricingTier.values().stream().filter(value -> StringUtils.equals((CharSequence)value.getSize(), (CharSequence)pricingTier.toSkuDescription().size()) && StringUtils.equals((CharSequence)value.getTier(), (CharSequence)pricingTier.toSkuDescription().tier())).findFirst().orElse(null);
    }

    static com.microsoft.azure.toolkits.appservice.model.OperatingSystem fromOperatingSystem(OperatingSystem operatingSystem) {
        return Arrays.stream(com.microsoft.azure.toolkits.appservice.model.OperatingSystem.values()).filter(os -> StringUtils.equals((CharSequence)operatingSystem.name(), (CharSequence)os.getValue())).findFirst().orElse(null);
    }

    static JavaVersion fromJavaVersion(com.azure.resourcemanager.appservice.models.JavaVersion javaVersion) {
        return JavaVersion.values().stream().filter(value -> StringUtils.equals((CharSequence)value.getValue(), (CharSequence)javaVersion.toString())).findFirst().orElse(null);
    }

    static com.azure.resourcemanager.appservice.models.JavaVersion toJavaVersion(JavaVersion javaVersion) {
        return com.azure.resourcemanager.appservice.models.JavaVersion.values().stream().filter(value -> StringUtils.equals((CharSequence)value.toString(), (CharSequence)javaVersion.getValue())).findFirst().orElse(null);
    }

    static WebAppEntity fromWebApp(WebAppBase webAppBase) {
        return ((WebAppEntity.WebAppEntityBuilder)((WebAppEntity.WebAppEntityBuilder)((WebAppEntity.WebAppEntityBuilder)((WebAppEntity.WebAppEntityBuilder)((WebAppEntity.WebAppEntityBuilder)((WebAppEntity.WebAppEntityBuilder)((WebAppEntity.WebAppEntityBuilder)((WebAppEntity.WebAppEntityBuilder)((WebAppEntity.WebAppEntityBuilder)WebAppEntity.builder().name(webAppBase.name())).id(webAppBase.id())).region(Region.fromName((String)webAppBase.regionName()))).resourceGroup(webAppBase.resourceGroupName())).subscriptionId(Utils.getSubscriptionId(webAppBase.id()))).runtime(null)).appServicePlanId(webAppBase.appServicePlanId())).defaultHostName(webAppBase.defaultHostname())).appSettings(Utils.normalizeAppSettings(webAppBase.getAppSettings()))).build();
    }

    static WebAppEntity fromWebAppBasic(WebAppBasic webAppBasic) {
        return ((WebAppEntity.WebAppEntityBuilder)((WebAppEntity.WebAppEntityBuilder)((WebAppEntity.WebAppEntityBuilder)((WebAppEntity.WebAppEntityBuilder)((WebAppEntity.WebAppEntityBuilder)((WebAppEntity.WebAppEntityBuilder)((WebAppEntity.WebAppEntityBuilder)WebAppEntity.builder().name(webAppBasic.name())).id(webAppBasic.id())).region(Region.fromName((String)webAppBasic.regionName()))).resourceGroup(webAppBasic.resourceGroupName())).subscriptionId(Utils.getSubscriptionId(webAppBasic.id()))).appServicePlanId(webAppBasic.appServicePlanId())).defaultHostName(webAppBasic.defaultHostname())).build();
    }

    static WebAppDeploymentSlotEntity fromWebAppDeploymentSlot(DeploymentSlot deploymentSlot) {
        return ((WebAppDeploymentSlotEntity.WebAppDeploymentSlotEntityBuilder)((WebAppDeploymentSlotEntity.WebAppDeploymentSlotEntityBuilder)((WebAppDeploymentSlotEntity.WebAppDeploymentSlotEntityBuilder)((WebAppDeploymentSlotEntity.WebAppDeploymentSlotEntityBuilder)((WebAppDeploymentSlotEntity.WebAppDeploymentSlotEntityBuilder)((WebAppDeploymentSlotEntity.WebAppDeploymentSlotEntityBuilder)((WebAppDeploymentSlotEntity.WebAppDeploymentSlotEntityBuilder)((WebAppDeploymentSlotEntity.WebAppDeploymentSlotEntityBuilder)((WebAppDeploymentSlotEntity.WebAppDeploymentSlotEntityBuilder)WebAppDeploymentSlotEntity.builder().name(deploymentSlot.name())).webappName(((WebApp)deploymentSlot.parent()).name())).id(deploymentSlot.id())).resourceGroup(deploymentSlot.resourceGroupName())).subscriptionId(Utils.getSubscriptionId(deploymentSlot.id()))).runtime(null)).appServicePlanId(deploymentSlot.appServicePlanId())).defaultHostName(deploymentSlot.defaultHostname())).appSettings(Utils.normalizeAppSettings(deploymentSlot.getAppSettings()))).build();
    }

    static AppServicePlanEntity fromAppServicePlan(AppServicePlan appServicePlan) {
        return ((AppServicePlanEntity.AppServicePlanEntityBuilder)((AppServicePlanEntity.AppServicePlanEntityBuilder)((AppServicePlanEntity.AppServicePlanEntityBuilder)((AppServicePlanEntity.AppServicePlanEntityBuilder)((AppServicePlanEntity.AppServicePlanEntityBuilder)((AppServicePlanEntity.AppServicePlanEntityBuilder)AppServicePlanEntity.builder().id(appServicePlan.id())).name(appServicePlan.name())).region(appServicePlan.regionName())).resourceGroup(appServicePlan.resourceGroupName())).pricingTier(AppServiceUtils.fromPricingTier(appServicePlan.pricingTier()))).operatingSystem(AppServiceUtils.fromOperatingSystem(appServicePlan.operatingSystem()))).build();
    }

    static AppServicePlan getAppServicePlan(AppServicePlanEntity entity, AzureResourceManager azureClient) {
        try {
            return StringUtils.isNotEmpty((CharSequence)entity.getId()) ? (AppServicePlan)azureClient.appServicePlans().getById(entity.getId()) : (AppServicePlan)azureClient.appServicePlans().getByResourceGroup(entity.getResourceGroup(), entity.getName());
        }
        catch (ManagementException e) {
            return null;
        }
    }
}

