/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkits.appservice.service.impl;

import com.azure.resourcemanager.AzureResourceManager;
import com.azure.resourcemanager.appservice.AppServiceManager;
import com.azure.resourcemanager.appservice.models.AppServicePlan;
import com.azure.resourcemanager.appservice.models.OperatingSystem;
import com.azure.resourcemanager.appservice.models.PricingTier;
import com.microsoft.azure.toolkits.appservice.AzureAppService;
import com.microsoft.azure.toolkits.appservice.entity.AppServicePlanEntity;
import com.microsoft.azure.toolkits.appservice.service.IAppServicePlan;
import com.microsoft.azure.toolkits.appservice.service.IAppServicePlanCreator;
import com.microsoft.azure.toolkits.appservice.service.IAppServicePlanUpdater;
import com.microsoft.azure.toolkits.appservice.service.IWebApp;
import com.microsoft.azure.toolkits.appservice.service.impl.AppServiceUtils;
import com.microsoft.azure.toolkits.appservice.service.impl.WebApp;
import com.microsoft.azure.tools.common.model.Region;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class AppServicePlan
implements IAppServicePlan {
    private AppServicePlanEntity entity;
    private AzureAppService azureAppService;
    private AzureResourceManager azureClient;
    private com.azure.resourcemanager.appservice.models.AppServicePlan appServicePlanInner;

    public AppServicePlan(AppServicePlanEntity appServicePlanEntity, AzureAppService appService) {
        this.entity = appServicePlanEntity;
        this.azureAppService = appService;
        this.azureClient = appService.getAzureResourceManager();
    }

    @Override
    public IAppServicePlanCreator create() {
        return new AppServicePlanCreator();
    }

    @Override
    public boolean exists() {
        this.refreshAppServicePlanInner();
        return this.appServicePlanInner != null;
    }

    @Override
    public AppServicePlanEntity entity() {
        return this.entity;
    }

    @Override
    public List<IWebApp> webapps() {
        return ((AppServiceManager)this.getAppServicePlanInner().manager()).webApps().list().stream().filter(webapp -> StringUtils.equals((CharSequence)webapp.appServicePlanId(), (CharSequence)this.getAppServicePlanInner().id())).map(webapp -> new WebApp(AppServiceUtils.fromWebAppBasic(webapp), this.azureAppService)).collect(Collectors.toList());
    }

    @Override
    public AppServicePlanUpdater update() {
        return new AppServicePlanUpdater();
    }

    public com.azure.resourcemanager.appservice.models.AppServicePlan getAppServicePlanInner() {
        if (this.appServicePlanInner == null) {
            this.refreshAppServicePlanInner();
        }
        return this.appServicePlanInner;
    }

    public synchronized void refreshAppServicePlanInner() {
        this.appServicePlanInner = AppServiceUtils.getAppServicePlan(this.entity, this.azureClient);
    }

    @Override
    public String id() {
        return this.getAppServicePlanInner().id();
    }

    @Override
    public String name() {
        return this.getAppServicePlanInner().name();
    }

    public class AppServicePlanUpdater
    implements IAppServicePlanUpdater {
        private Optional<com.microsoft.azure.toolkits.appservice.model.PricingTier> pricingTier;

        @Override
        public AppServicePlanUpdater withPricingTier(com.microsoft.azure.toolkits.appservice.model.PricingTier pricingTier) {
            this.pricingTier = Optional.of(pricingTier);
            return this;
        }

        @Override
        public AppServicePlan commit() {
            PricingTier newPricingTier;
            boolean modified = false;
            AppServicePlan.Update update = (AppServicePlan.Update)AppServicePlan.this.appServicePlanInner.update();
            if (this.pricingTier != null && this.pricingTier.isPresent() && !Objects.equals(newPricingTier = AppServiceUtils.toPricingTier(this.pricingTier.get()), AppServicePlan.this.getAppServicePlanInner().pricingTier())) {
                modified = true;
                update = update.withPricingTier(newPricingTier);
            }
            if (modified) {
                AppServicePlan.this.appServicePlanInner = (com.azure.resourcemanager.appservice.models.AppServicePlan)update.apply();
            }
            AppServicePlan.this.entity = AppServiceUtils.fromAppServicePlan(AppServicePlan.this.appServicePlanInner);
            return AppServicePlan.this;
        }
    }

    public class AppServicePlanCreator
    implements IAppServicePlanCreator {
        private String name;
        private Region region;
        private String resourceGroup;
        private com.microsoft.azure.toolkits.appservice.model.PricingTier pricingTier;
        private com.microsoft.azure.toolkits.appservice.model.OperatingSystem operatingSystem;

        @Override
        public IAppServicePlanCreator withName(String name) {
            this.name = name;
            return this;
        }

        @Override
        public IAppServicePlanCreator withRegion(Region region) {
            this.region = region;
            return this;
        }

        @Override
        public IAppServicePlanCreator withResourceGroup(String resourceGroup) {
            this.resourceGroup = resourceGroup;
            return this;
        }

        @Override
        public IAppServicePlanCreator withPricingTier(com.microsoft.azure.toolkits.appservice.model.PricingTier pricingTier) {
            this.pricingTier = pricingTier;
            return this;
        }

        @Override
        public IAppServicePlanCreator withOperatingSystem(com.microsoft.azure.toolkits.appservice.model.OperatingSystem operatingSystem) {
            this.operatingSystem = operatingSystem;
            return this;
        }

        @Override
        public IAppServicePlan commit() {
            AppServicePlan.this.appServicePlanInner = (com.azure.resourcemanager.appservice.models.AppServicePlan)((AppServicePlan.DefinitionStages.WithPricingTier)((AppServicePlan.DefinitionStages.WithGroup)((AppServicePlan.DefinitionStages.Blank)AppServicePlan.this.azureClient.appServicePlans().define(this.name)).withRegion(this.region.getName())).withExistingResourceGroup(this.resourceGroup)).withPricingTier(AppServiceUtils.toPricingTier(this.pricingTier)).withOperatingSystem(this.convertOS(this.operatingSystem)).create();
            AppServicePlan.this.entity = AppServiceUtils.fromAppServicePlan(AppServicePlan.this.appServicePlanInner);
            return AppServicePlan.this;
        }

        private OperatingSystem convertOS(com.microsoft.azure.toolkits.appservice.model.OperatingSystem operatingSystem) {
            return operatingSystem == com.microsoft.azure.toolkits.appservice.model.OperatingSystem.WINDOWS ? OperatingSystem.WINDOWS : OperatingSystem.LINUX;
        }
    }
}

