/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkits.appservice.service;

import com.microsoft.azure.toolkits.appservice.model.DeployType;
import com.microsoft.azure.toolkits.appservice.model.PublishingProfile;
import com.microsoft.azure.toolkits.appservice.model.Runtime;
import com.microsoft.azure.toolkits.appservice.model.WebAppArtifact;
import com.microsoft.azure.toolkits.appservice.service.IResource;
import com.microsoft.azure.toolkits.appservice.utils.Utils;
import java.io.File;

public interface IAppService
extends IResource {
    public void start();

    public void stop();

    public void restart();

    public void delete();

    default public void deploy(File targetFile) {
        this.deploy(Utils.getDeployTypeByFileExtension(targetFile), targetFile);
    }

    default public void deploy(DeployType deployType, File targetFile) {
        this.deploy(deployType, targetFile, null);
    }

    default public void deploy(WebAppArtifact webAppArtifact) {
        this.deploy(webAppArtifact.getDeployType(), webAppArtifact.getFile(), webAppArtifact.getPath());
    }

    public void deploy(DeployType var1, File var2, String var3);

    public boolean exists();

    public String hostName();

    public String state();

    public Runtime getRuntime();

    public PublishingProfile getPublishingProfile();
}

