/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkits.appservice.service;

import com.microsoft.azure.toolkits.appservice.entity.AppServicePlanEntity;
import com.microsoft.azure.toolkits.appservice.model.DockerConfiguration;
import com.microsoft.azure.toolkits.appservice.model.PricingTier;
import com.microsoft.azure.toolkits.appservice.model.Runtime;
import com.microsoft.azure.toolkits.appservice.service.IAppServiceUpdater;
import java.util.Map;
import java.util.Optional;

public abstract class AbstractAppServiceUpdater<T>
implements IAppServiceUpdater {
    private Optional<DockerConfiguration> dockerConfiguration = null;
    private Optional<Runtime> runtime = null;
    private Optional<PricingTier> pricingTier = null;
    private Optional<AppServicePlanEntity> appServicePlan = null;
    private Optional<Map<String, String>> appSettings = null;

    public IAppServiceUpdater withPlan(String appServicePlanId) {
        this.appServicePlan = Optional.of(((AppServicePlanEntity.AppServicePlanEntityBuilder)AppServicePlanEntity.builder().id(appServicePlanId)).build());
        return this;
    }

    public IAppServiceUpdater withPlan(String resourceGroup, String planName) {
        this.appServicePlan = Optional.of(((AppServicePlanEntity.AppServicePlanEntityBuilder)((AppServicePlanEntity.AppServicePlanEntityBuilder)AppServicePlanEntity.builder().resourceGroup(resourceGroup)).name(planName)).build());
        return this;
    }

    @Override
    public IAppServiceUpdater<T> withRuntime(Runtime runtime) {
        this.runtime = Optional.ofNullable(runtime);
        return this;
    }

    public IAppServiceUpdater withDockerConfiguration(DockerConfiguration dockerConfiguration) {
        this.dockerConfiguration = Optional.ofNullable(dockerConfiguration);
        return this;
    }

    public IAppServiceUpdater<T> withAppSettings(Map appSettings) {
        this.appSettings = Optional.ofNullable(appSettings);
        return this;
    }

    public Optional<DockerConfiguration> getDockerConfiguration() {
        return this.dockerConfiguration;
    }

    public Optional<Runtime> getRuntime() {
        return this.runtime;
    }

    public Optional<PricingTier> getPricingTier() {
        return this.pricingTier;
    }

    public Optional<AppServicePlanEntity> getAppServicePlan() {
        return this.appServicePlan;
    }

    public Optional<Map<String, String>> getAppSettings() {
        return this.appSettings;
    }
}

