/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkits.appservice.model;

import com.microsoft.azure.toolkits.appservice.model.JavaVersion;
import com.microsoft.azure.toolkits.appservice.model.OperatingSystem;
import com.microsoft.azure.toolkits.appservice.model.WebContainer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class Runtime {
    public static final Runtime WINDOWS_JAVA8 = new Runtime(OperatingSystem.WINDOWS, WebContainer.JAVA_SE, JavaVersion.JAVA_8);
    public static final Runtime WINDOWS_JAVA11 = new Runtime(OperatingSystem.WINDOWS, WebContainer.JAVA_SE, JavaVersion.JAVA_11);
    public static final Runtime WINDOWS_JAVA8_TOMCAT9 = new Runtime(OperatingSystem.WINDOWS, WebContainer.TOMCAT_9, JavaVersion.JAVA_8);
    public static final Runtime WINDOWS_JAVA8_TOMCAT85 = new Runtime(OperatingSystem.WINDOWS, WebContainer.TOMCAT_85, JavaVersion.JAVA_8);
    public static final Runtime WINDOWS_JAVA11_TOMCAT9 = new Runtime(OperatingSystem.WINDOWS, WebContainer.TOMCAT_9, JavaVersion.JAVA_11);
    public static final Runtime WINDOWS_JAVA11_TOMCAT85 = new Runtime(OperatingSystem.WINDOWS, WebContainer.TOMCAT_85, JavaVersion.JAVA_11);
    public static final Runtime LINUX_JAVA8 = new Runtime(OperatingSystem.LINUX, WebContainer.JAVA_SE, JavaVersion.JAVA_8);
    public static final Runtime LINUX_JAVA11 = new Runtime(OperatingSystem.LINUX, WebContainer.JAVA_SE, JavaVersion.JAVA_11);
    public static final Runtime LINUX_JAVA8_TOMCAT9 = new Runtime(OperatingSystem.LINUX, WebContainer.TOMCAT_9, JavaVersion.JAVA_8);
    public static final Runtime LINUX_JAVA8_TOMCAT85 = new Runtime(OperatingSystem.LINUX, WebContainer.TOMCAT_85, JavaVersion.JAVA_8);
    public static final Runtime LINUX_JAVA8_JBOSS72 = new Runtime(OperatingSystem.LINUX, WebContainer.JBOSS_72, JavaVersion.JAVA_8);
    public static final Runtime LINUX_JAVA11_TOMCAT9 = new Runtime(OperatingSystem.LINUX, WebContainer.TOMCAT_9, JavaVersion.JAVA_11);
    public static final Runtime LINUX_JAVA11_TOMCAT85 = new Runtime(OperatingSystem.LINUX, WebContainer.TOMCAT_85, JavaVersion.JAVA_11);
    public static final Runtime DOCKER = new Runtime(OperatingSystem.DOCKER, null, null);
    private static final List<Runtime> values = Collections.unmodifiableList(Arrays.asList(WINDOWS_JAVA8, WINDOWS_JAVA11, WINDOWS_JAVA8_TOMCAT9, WINDOWS_JAVA8_TOMCAT85, WINDOWS_JAVA11_TOMCAT9, WINDOWS_JAVA11_TOMCAT85, LINUX_JAVA8, LINUX_JAVA11, LINUX_JAVA8_TOMCAT9, LINUX_JAVA8_TOMCAT85, LINUX_JAVA8_JBOSS72, LINUX_JAVA11_TOMCAT9, LINUX_JAVA11_TOMCAT85));
    private OperatingSystem operatingSystem;
    private WebContainer webContainer;
    private JavaVersion javaVersion;

    public static Runtime getRuntime(OperatingSystem operatingSystem, WebContainer webContainer, JavaVersion javaVersion) {
        Runtime standardRuntime = Runtime.values().stream().filter(runtime -> Objects.equals((Object)runtime.operatingSystem, (Object)operatingSystem)).filter(runtime -> Objects.equals(runtime.webContainer, webContainer)).filter(runtime -> Objects.equals(runtime.javaVersion, javaVersion)).findFirst().orElse(null);
        if (standardRuntime != null) {
            return standardRuntime;
        }
        return new Runtime(operatingSystem, webContainer, javaVersion);
    }

    public static Runtime getRuntimeFromLinuxFxVersion(String linuxFxVersion) {
        String[] runtimeDetails = linuxFxVersion.split("-");
        if (runtimeDetails.length != 2) {
            return null;
        }
        String javaVersionRaw = runtimeDetails[1];
        String webContainerRaw = runtimeDetails[0];
        JavaVersion javaVersion = StringUtils.containsIgnoreCase((CharSequence)javaVersionRaw, (CharSequence)"java11") ? JavaVersion.JAVA_11 : JavaVersion.JAVA_8;
        WebContainer webContainer = WebContainer.fromString(webContainerRaw);
        return Runtime.getRuntime(OperatingSystem.LINUX, webContainer, javaVersion);
    }

    public static List<Runtime> values() {
        return values;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Runtime)) {
            return false;
        }
        Runtime runtime = (Runtime)o;
        return this.operatingSystem == runtime.operatingSystem && Objects.equals(this.webContainer, runtime.webContainer) && Objects.equals(this.javaVersion, runtime.javaVersion);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.operatingSystem, this.webContainer, this.javaVersion});
    }

    public OperatingSystem getOperatingSystem() {
        return this.operatingSystem;
    }

    public WebContainer getWebContainer() {
        return this.webContainer;
    }

    public JavaVersion getJavaVersion() {
        return this.javaVersion;
    }

    public Runtime(OperatingSystem operatingSystem, WebContainer webContainer, JavaVersion javaVersion) {
        this.operatingSystem = operatingSystem;
        this.webContainer = webContainer;
        this.javaVersion = javaVersion;
    }
}

