/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkits.appservice;

import com.azure.resourcemanager.AzureResourceManager;
import com.microsoft.azure.toolkits.appservice.entity.AppServicePlanEntity;
import com.microsoft.azure.toolkits.appservice.entity.WebAppDeploymentSlotEntity;
import com.microsoft.azure.toolkits.appservice.entity.WebAppEntity;
import com.microsoft.azure.toolkits.appservice.service.IAppServicePlan;
import com.microsoft.azure.toolkits.appservice.service.IWebApp;
import com.microsoft.azure.toolkits.appservice.service.IWebAppDeploymentSlot;
import com.microsoft.azure.toolkits.appservice.service.impl.AppServicePlan;
import com.microsoft.azure.toolkits.appservice.service.impl.WebApp;
import com.microsoft.azure.toolkits.appservice.service.impl.WebAppDeploymentSlot;
import java.util.List;
import java.util.stream.Collectors;

public class AzureAppService {
    private AzureResourceManager azureResourceManager;

    private AzureAppService(AzureResourceManager azureResourceManager) {
        this.azureResourceManager = azureResourceManager;
    }

    public static AzureAppService auth(AzureResourceManager azureResourceManager) {
        return new AzureAppService(azureResourceManager);
    }

    public IWebApp webapp(String id) {
        Object webAppEntity = ((WebAppEntity.WebAppEntityBuilder)WebAppEntity.builder().id(id)).build();
        return this.webapp((WebAppEntity)webAppEntity);
    }

    public IWebApp webapp(String resourceGroup, String name) {
        Object webAppEntity = ((WebAppEntity.WebAppEntityBuilder)((WebAppEntity.WebAppEntityBuilder)WebAppEntity.builder().resourceGroup(resourceGroup)).name(name)).build();
        return this.webapp((WebAppEntity)webAppEntity);
    }

    public IWebApp webapp(WebAppEntity webAppEntity) {
        return new WebApp(webAppEntity, this);
    }

    public List<IWebApp> webapps() {
        return this.azureResourceManager.webApps().list().stream().map(webAppBasic -> this.webapp(webAppBasic.id())).collect(Collectors.toList());
    }

    public IAppServicePlan appServicePlan(AppServicePlanEntity appServicePlanEntity) {
        return new AppServicePlan(appServicePlanEntity, this);
    }

    public IAppServicePlan appServicePlan(String id) {
        Object appServicePlanEntity = ((AppServicePlanEntity.AppServicePlanEntityBuilder)AppServicePlanEntity.builder().id(id)).build();
        return this.appServicePlan((AppServicePlanEntity)appServicePlanEntity);
    }

    public IAppServicePlan appServicePlan(String resourceGroup, String name) {
        Object appServicePlanEntity = ((AppServicePlanEntity.AppServicePlanEntityBuilder)((AppServicePlanEntity.AppServicePlanEntityBuilder)AppServicePlanEntity.builder().resourceGroup(resourceGroup)).name(name)).build();
        return this.appServicePlan((AppServicePlanEntity)appServicePlanEntity);
    }

    public List<IAppServicePlan> appServicePlans() {
        return this.azureResourceManager.appServicePlans().list().stream().map(appServicePlan -> this.appServicePlan(appServicePlan.id())).collect(Collectors.toList());
    }

    public IWebAppDeploymentSlot deploymentSlot(String id) {
        return this.deploymentSlot((WebAppDeploymentSlotEntity)((WebAppDeploymentSlotEntity.WebAppDeploymentSlotEntityBuilder)WebAppDeploymentSlotEntity.builder().id(id)).build());
    }

    public IWebAppDeploymentSlot deploymentSlot(String resourceGroup, String appName, String slotName) {
        return this.deploymentSlot((WebAppDeploymentSlotEntity)((WebAppDeploymentSlotEntity.WebAppDeploymentSlotEntityBuilder)((WebAppDeploymentSlotEntity.WebAppDeploymentSlotEntityBuilder)((WebAppDeploymentSlotEntity.WebAppDeploymentSlotEntityBuilder)WebAppDeploymentSlotEntity.builder().resourceGroup(resourceGroup)).webappName(appName)).name(slotName)).build());
    }

    public IWebAppDeploymentSlot deploymentSlot(WebAppDeploymentSlotEntity deploymentSlot) {
        return new WebAppDeploymentSlot(deploymentSlot, this);
    }

    public AzureResourceManager getAzureResourceManager() {
        return this.azureResourceManager;
    }
}

