/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.storage;

import com.microsoft.azure.storage.OperationContext;
import com.microsoft.azure.storage.StorageCredentials;
import com.microsoft.azure.storage.StorageUri;
import java.net.URI;

public final class StorageCredentialsToken
extends StorageCredentials {
    private volatile String token;
    private volatile String accountName;

    public StorageCredentialsToken(String accountName, String token) {
        this.accountName = accountName;
        this.token = token;
    }

    @Override
    public boolean isHttpsOnly() {
        return true;
    }

    public String getToken() {
        return this.token;
    }

    public synchronized void updateToken(String token) {
        this.token = token;
    }

    @Override
    public String getAccountName() {
        return this.accountName;
    }

    @Override
    public String toString(boolean exportSecrets) {
        return String.format("%s=%s", "AccountToken", exportSecrets ? this.token : "[token hidden]");
    }

    @Override
    public URI transformUri(URI resourceUri, OperationContext opContext) {
        return resourceUri;
    }

    @Override
    public StorageUri transformUri(StorageUri resourceUri, OperationContext opContext) {
        return resourceUri;
    }
}

