/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.storage.core;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.microsoft.azure.storage.core.EncryptionAgent;
import com.microsoft.azure.storage.core.JsonUtilities;
import com.microsoft.azure.storage.core.Utility;
import com.microsoft.azure.storage.core.WrappedContentKey;
import java.io.IOException;
import java.io.StringWriter;

public class EncryptionData {
    private byte[] contentEncryptionIV;
    private EncryptionAgent encryptionAgent;
    private WrappedContentKey wrappedContentKey;

    public byte[] getContentEncryptionIV() {
        return this.contentEncryptionIV;
    }

    public EncryptionAgent getEncryptionAgent() {
        return this.encryptionAgent;
    }

    public WrappedContentKey getWrappedContentKey() {
        return this.wrappedContentKey;
    }

    public void setContentEncryptionIV(byte[] contentEncryptionIV) {
        this.contentEncryptionIV = contentEncryptionIV;
    }

    public void setEncryptionAgent(EncryptionAgent encryptionAgent) {
        this.encryptionAgent = encryptionAgent;
    }

    public void setWrappedContentKey(WrappedContentKey wrappedContentKey) {
        this.wrappedContentKey = wrappedContentKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String serialize() throws IOException {
        StringWriter strWriter = new StringWriter();
        JsonGenerator generator = Utility.getJsonGenerator(strWriter);
        try {
            generator.writeStartObject();
            this.serialize(generator);
            generator.writeEndObject();
        }
        finally {
            generator.close();
        }
        return strWriter.toString();
    }

    public void serialize(JsonGenerator generator) throws IOException {
        generator.writeObjectFieldStart("WrappedContentKey");
        this.getWrappedContentKey().serialize(generator);
        generator.writeEndObject();
        generator.writeObjectFieldStart("EncryptionAgent");
        this.getEncryptionAgent().serialize(generator);
        generator.writeEndObject();
        generator.writeBinaryField("ContentEncryptionIV", this.getContentEncryptionIV());
    }

    public void copyValues(EncryptionData data) throws JsonProcessingException, IOException {
        this.setWrappedContentKey(data.getWrappedContentKey());
        this.setEncryptionAgent(data.getEncryptionAgent());
        this.setContentEncryptionIV(data.getContentEncryptionIV());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EncryptionData deserialize(String inputData) throws JsonProcessingException, IOException {
        JsonParser parser = Utility.getJsonParser(inputData);
        try {
            if (!parser.hasCurrentToken()) {
                parser.nextToken();
            }
            EncryptionData encryptionData = EncryptionData.deserialize(parser);
            return encryptionData;
        }
        finally {
            parser.close();
        }
    }

    public static EncryptionData deserialize(JsonParser parser) throws JsonParseException, IOException {
        JsonUtilities.assertIsStartObjectJsonToken(parser);
        parser.nextToken();
        EncryptionData data = new EncryptionData();
        while (parser.getCurrentToken() != JsonToken.END_OBJECT) {
            String name = parser.getCurrentName();
            parser.nextToken();
            if (name.equals("WrappedContentKey")) {
                data.setWrappedContentKey(WrappedContentKey.deserialize(parser));
            } else if (name.equals("EncryptionAgent")) {
                data.setEncryptionAgent(EncryptionAgent.deserialize(parser));
            } else if (name.equals("ContentEncryptionIV")) {
                data.setContentEncryptionIV(parser.getBinaryValue());
            }
            parser.nextToken();
        }
        JsonUtilities.assertIsEndObjectJsonToken(parser);
        return data;
    }
}

